package ad

import (
	"alpha/adDelivery/structure"
	"fmt"
	"strconv"
	"strings"
	"alpha/adDelivery/capping"
	"alpha/adDelivery/deliveryLimitation"
	"alpha/adDelivery/helper"
	 config "alpha/configuration"
	 	"github.com/elliotchance/phpserialize"	

	"alpha/db"
	"math/rand"
	"net/http"
	"crypto/md5"
	"encoding/hex"
	"time" 
		"path"
			"encoding/json"


)


import "alpha/redisClient"



var redisClients = redisClient.Initialize()




func GetLinkedAdZone(r *http.Request,zn structure.ZoneInfo,ad_type string) map[string][]structure.AdLinkedZone  {
	
	 
	
	
	table_prefix := config.GetConfig("prefix","table")
	
	var extraQuery_join string
	var extraQuery_where string
	 
	 if ad_type =="vid" {
		 	
		 		vast := helper.GetUrlParam(r,"vast")

		 if vast !="" {
			 
		protocal := 0
		lineatity := 0
		ad_type := 0
			
		switch (vast) {
		
			case "vast2" :
				protocal = 1
				lineatity = 1
			case "vast3" :
				protocal = 2
				lineatity = 1
			case "vast4" :
				protocal = 3
				lineatity = 1
			case "vast4_1" :
				protocal = 4
				lineatity = 1
				
			case "vast2_wrapper" :
				protocal = 1
				lineatity = 2
			case "vast3_wrapper" :
				protocal = 2
				lineatity = 2
			case "vast4_wrapper" :
				protocal = 3
				lineatity = 2
			case "vast4_1_wrapper" :
				protocal = 4
				lineatity = 2
			case "daast_1" :
				protocal = 4
				lineatity = 1
				ad_type = 1
		}
				
		extraQuery_join =" INNER JOIN "+table_prefix+"djaxbanner_vast_element as vast on d.bannerid = vast.banner_id "
		extraQuery_where =" AND vast.vast_type = %d AND  vast.get_third_internal_type = %d "
		if ad_type == 1 {
			extraQuery_where = extraQuery_where+" AND vast.ad_type = 1"
		}
		
		extraQuery_where = fmt.Sprintf(extraQuery_where,protocal,lineatity)
		}
	 }
	  
	 	 adQuery := "SELECT d.bannerid AS ad_id, d.campaignid AS placement_id, d.status AS status, d.width AS width, IF(d.ext_bannertype != NULL,d.ext_bannertype, '') as ext_bannertype, d.height AS height, d.storagetype AS type, d.contenttype AS contenttype, d.weight AS weight, d.adserver AS adserver, d.block AS block_ad, d.capping AS cap_ad, d.session_capping AS session_cap_ad, d.compiledlimitation AS compiledlimitation, IF(d.acl_plugins != NULL,d.acl_plugins, '') AS acl_plugins, d.alt_filename AS alt_filename, az.priority AS priority, az.priority_factor AS priority_factor, az.to_be_delivered AS to_be_delivered, c.campaignid AS campaign_id, c.priority AS campaign_priority, c.weight AS campaign_weight, c.companion AS campaign_companion, c.block AS block_campaign, c.capping AS cap_campaign, c.session_capping AS session_cap_campaign, c.show_capped_no_cookie AS show_capped_no_cookie, c.clientid AS client_id,IF(c.expire_time != NULL,c.expire_time, '')  AS expire_time, c.revenue_type AS revenue_type, c.ecpm_enabled AS ecpm_enabled, IF(c.ecpm != NULL,c.ecpm, 0.00) AS ecpm, IF(ct.status != NULL,ct.status, 0) AS tracker_status FROM "+table_prefix+"banners AS d JOIN "+table_prefix+"ad_zone_assoc AS az ON (d.bannerid = az.ad_id) JOIN "+table_prefix+"campaigns AS c ON (c.campaignid = d.campaignid) LEFT JOIN "+table_prefix+"clients AS cl ON (cl.clientid = c.clientid) LEFT JOIN "+table_prefix+"campaigns_trackers AS ct ON (ct.campaignid = c.campaignid) "+extraQuery_join+" WHERE az.zone_id = %d AND d.status <= 0 AND c.budget_status <= 0 AND cl.payment_status <= 0 AND c.status <= 0 "+extraQuery_where
	 	 
	 	 
	 	 
	 
	 adQuery = fmt.Sprintf(adQuery,zn.Zoneid)
	 
	 
	
	 rows, err := db.DbQuery(adQuery)
	 
	 
	 
	  if err != nil {
        fmt.Println("Failed to run query", err)
		}
			
		var ad_xAds [] structure.AdLinkedZone 
		var ad_ads [] structure.AdLinkedZone 
		var ad_lAds [] structure.AdLinkedZone 
		var ad_eAds [] structure.AdLinkedZone 
				
			 ads := make(map[string][]structure.AdLinkedZone)
		

		for rows.Next() {
		a := structure.AdLinkedZone{}
		
		 err = helper.Scan(&a, rows)
		 
			 if err != nil {
				fmt.Println("Failed to run query", err)
				}	else	{
					
					
						if a.Campaign_priority == -1 {
							  ad_xAds = append(ad_xAds, a)
							
						} else if a.Campaign_priority == 0 {
							
						 ad_lAds = append(ad_lAds, a)	
						} else if a.Campaign_priority == -2 {
							
						 ad_eAds = append(ad_eAds, a)	
						} else {
							ad_ads = append(ad_ads, a)	
						}
				}
				
				
		
			
		}
		ads["xAds"] = ad_xAds
		ads["lAds"] = ad_lAds
		ads["eAds"] = ad_eAds
		ads["ads"] = ad_ads 
	      

		return  ads
	 
}



func CheckAdCriteria(r *http.Request, ads_info map[string][]structure.AdLinkedZone , zninfo structure.ZoneInfo) ( []structure.AdLinkedZone , string) {
	
		var finalAds [] structure.AdLinkedZone
		var campaign_type string
		campaigns := [4]string{"xAds","lAds","eAds","ads"} 
		
	
		for  _,i := range campaigns  { 
		
			c_ads := ads_info[i]
			
				for _, banner := range c_ads { 
					
					ChZoneCap := capping.CheckCaping(r,zninfo.Zoneid,zninfo.Block,zninfo.Capping,zninfo.Session_capping,"zone")
					if ChZoneCap == false  {	continue; 	}
					
					ChBannerCap := capping.CheckCaping(r,banner.Ad_id,banner.Block_ad,banner.Cap_ad,banner.Session_cap_ad,"banner")
					if ChBannerCap == false  {	continue; 	}
					
					 ChCampaignCap := capping.CheckCaping(r,banner.Campaign_id,banner.Block_campaign,banner.Cap_campaign,banner.Session_cap_campaign,"campaign")
					 if ChCampaignCap == false  { 	continue ;	}

					 ChDeliveyLimit := deliveryLimitation.CheckAcls(banner,zninfo,r)
					 if ChDeliveyLimit == false  {  	continue ;}
					 
						finalAds = append(finalAds,banner)	
						
					}
					
					if len(finalAds) > 0 { 	campaign_type = i; 	break;	}
					
					
					
					
			}
	
	
	return finalAds , campaign_type
	
}




func AdSelect(campaign_type string,ads_info []structure.AdLinkedZone ,zone_info structure.ZoneInfo ) structure.AdDetails  {
	
	adDetails := structure.AdDetails{} 
	
	
	var totalPri int


	if campaign_type == "xAds"  || campaign_type == "lAds"  { 
		
		totalPri = SetPriorityFromWeights(&ads_info)
		
	} else if campaign_type == "ads"  {
		
		totalPri = 1
	}
	
	   

	
	rt :=  rand.Intn(99999)
	
	random_num := float64(rand.Intn(rt))/ float64(rt)
	
	  if (float64(random_num) > float64(totalPri) ) {
	return  adDetails 
}
	
	var low  float64;
	var high float64;

	for _,aAds := range ads_info {
		
		if campaign_type == "ads"  {
		
		aAds.PriorityFinal = 1
	} 
		
		if aAds.PriorityFinal != 0 {
			
			low = high
			high += float64(aAds.PriorityFinal)
			
			if high > random_num && low < random_num {
				
				 return  GetAd(aAds.Ad_id,adDetails)
			}
		}
		
		
	}
	
	
	return  adDetails

} 




func SetPriorityFromWeights(adsinfo *[]structure.AdLinkedZone) int {
	
	ads_info := *adsinfo
	
	if len(ads_info) == 0 {
			return 0
	}
	
	aCampaignWeights := make(map[int]float64)
	aCampaignAdWeight := make(map[int]float64)
	
	for _,adinfo := range ads_info {
		
		if _,ok:=aCampaignWeights[adinfo.Placement_id]; !ok{ 
			
			aCampaignWeights[adinfo.Placement_id] = float64(adinfo.Campaign_weight)
			aCampaignAdWeight[adinfo.Placement_id] = 0
		}
		
		aCampaignAdWeight[adinfo.Placement_id]+= float64(adinfo.Weight)

		
	}
	
	for k,_ := range aCampaignWeights {
		
		if _,ok:=aCampaignAdWeight[k]; ok{ 
			
			aCampaignWeights[k] /= aCampaignAdWeight[k];
		}
		
		
	}
	
	var totalPri float64
	
	
	for k,adinfo := range ads_info {
		ads_info[k].PriorityFinal = aCampaignWeights[adinfo.Placement_id] * float64(adinfo.Weight)
		totalPri +=  ads_info[k].PriorityFinal
	}
	
	if totalPri >0 {
		
		for k,_ := range ads_info {
			ads_info[k].PriorityFinal /=totalPri
		
		}
		
		return 1

	}
	
	return 0
	
	
}




func GetAd(ad_id int, adDetails structure.AdDetails ) structure.AdDetails {
	
	
		ad_id_str := strconv.Itoa(ad_id)

	
	redisClients.GetKey("adid"+ad_id_str,&adDetails)
		
	
	if adDetails.Ad_id != 0 {
		
		 return adDetails
	} 
 	
	
	
		table_prefix := config.GetConfig("prefix","table")

 
	 	 adQuery := "SELECT d.bannerid AS ad_id, d.campaignid AS placement_id, d.status AS status, d.description AS name, d.storagetype AS type, d.contenttype AS contenttype, d.pluginversion AS pluginversion, d.filename AS filename, d.imageurl AS imageurl, d.htmltemplate AS htmltemplate, d.htmlcache AS htmlcache, d.width AS width, d.height AS height, d.weight AS weight, d.seq AS seq, d.target AS target, d.url AS url, d.alt AS alt, d.statustext AS statustext, d.bannertext AS bannertext, d.adserver AS adserver, d.block AS block_ad, d.capping AS cap_ad, d.session_capping AS session_cap_ad, d.compiledlimitation AS compiledlimitation, d.acl_plugins AS acl_plugins, d.prepend AS prepend, d.append AS append, d.bannertype AS bannertype, d.alt_filename AS alt_filename, d.alt_imageurl AS alt_imageurl, d.alt_contenttype AS alt_contenttype, d.parameters AS parameters, d.transparent AS transparent, IF(d.ext_bannertype != NULL,d.ext_bannertype, '') as ext_bannertype, d.iframe_friendly AS iframe_friendly, c.campaignid AS campaign_id, c.block AS block_campaign, c.capping AS cap_campaign, c.session_capping AS session_cap_campaign, c.show_capped_no_cookie AS show_capped_no_cookie, m.clientid AS client_id, c.clickwindow AS clickwindow, c.viewwindow AS viewwindow, m.advertiser_limitation AS advertiser_limitation, m.agencyid AS agency_id, c.status AS campaign_status FROM "+table_prefix+"banners AS d, "+table_prefix+"campaigns AS c, "+table_prefix+"clients AS m WHERE d.bannerid=%d AND budget_status=0 AND payment_status=0 AND d.campaignid = c.campaignid AND m.clientid = c.clientid"
	 	
	  
	 adQuery = fmt.Sprintf(adQuery,ad_id)
	  

	 rows, err := db.DbQuery(adQuery)
	 
	 
	 fmt.Println(adQuery)
	 if err != nil {
        fmt.Println("Failed to run query", err)
		}
			
		

		for rows.Next() {
	
		
		 err = helper.Scan(&adDetails, rows)
		 
		 
		 redisClients.SetKey("adid"+ad_id_str,adDetails , time.Minute*5)
		
		 fmt.Println("ad Select From Quesry")
		 
		 
			 if err != nil {
				fmt.Println("Failed to run query", err)
				}
				
				
		
			
		}
		
		
		
	return adDetails
		
}




func AdRenderPassBack( zn structure.ZoneInfo, adDeliveryType string ) string {
	
	impurl := config.GetConfig( "protocol","webpath") + config.GetConfig("delivery","webpath") + "/lg.php?YmFubmVyaWQ==0&amp;Y2FtcGFpZ25pZA===0&amp;em9uZWlk=" + strconv.Itoa(zn.Zoneid)	
	
	if(adDeliveryType == "web") {
		
	return `<div>`+zn.Passbacktag+`<img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div>`

	} else {
		return `<div>`+zn.Passbacktag+`</div>`
	
	}
}



func AdRender(adDetails *structure.AdDetails, zn structure.ZoneInfo,adDeliveryType string) {
	
	clickurl := "" 
	clickTag_start := "" 
	clickTag_end := "" 
	ImgTag := ""
	 
	if adDetails.Url !=""  {
	clickurl = config.GetConfig( "protocol","webpath") + config.GetConfig("delivery","webpath") + "/ck.php?oaparams=2__bannerid=" + strconv.Itoa(adDetails.Ad_id) + "__campaignid=" + strconv.Itoa(adDetails.Placement_id) + "__zoneid="+ strconv.Itoa(zn.Zoneid)+"__oadest=" + adDetails.Url
		if adDeliveryType=="web" {	

	clickTag_start = `<a href='` + clickurl + `' target='_blank'>`
	clickTag_end = `</a>`
		}

	}
	
	impurl := config.GetConfig("protocol","webpath") + config.GetConfig("delivery","webpath") + "/lg.php?bannerid=" + strconv.Itoa(adDetails.Ad_id) + "&amp;campaignid=" + strconv.Itoa(adDetails.Placement_id) + "&amp;zoneid=" + strconv.Itoa(zn.Zoneid)
	
	impurl2 := config.GetConfig("protocol","webpath") + config.GetConfig("delivery","webpath") + "/lg.php?bannerid=" + strconv.Itoa(adDetails.Ad_id) + "&campaignid=" + strconv.Itoa(adDetails.Placement_id) + "&zoneid=" + strconv.Itoa(zn.Zoneid)
	
	if adDeliveryType=="web" {	
	ImgTag = `<img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
	}
	
	rand1 := helper.RandToken(5)
	
	adDetails.Imp_url = impurl
	adDetails.Click_url = clickurl

	if adDetails.Type == "web" {
		adDetails.Html = clickTag_start+`<img src='` + config.GetConfig( "protocol","webpath") + config.GetConfig( "images","webpath") + `/` + adDetails.Filename + `' width='` + strconv.Itoa(adDetails.Width) + `' height='` + strconv.Itoa(adDetails.Height) + `' alt='' title='' border='0' />`+clickTag_end+`<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'>`+ImgTag+`</div>`
 
	} else if adDetails.Type == "sql" {
		adDetails.Html = clickTag_start+`<img src='` + config.GetConfig("protocol","webpath") + config.GetConfig("delivery","webpath") + `/ai.php?filename=` + adDetails.Filename + `&contenttype=` + adDetails.Contenttype + `' width='` + strconv.Itoa(adDetails.Width) + `' height='` + strconv.Itoa(adDetails.Height) + `' alt='' title='' border='0' />`+clickTag_end+`<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div>`
	} else if adDetails.Type == "url" { 
		adDetails.Html = clickTag_start+`<img src='` + adDetails.Imageurl + `' width='` + strconv.Itoa(adDetails.Width) + `' height='` + strconv.Itoa(adDetails.Height) + `' alt='' title='' border='0' />`+clickTag_end+`<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'>`+ImgTag+`</div>`
	} else if adDetails.Type == "txt" {
		adDetails.Html = clickTag_start+`` + adDetails.Bannertext + ``+clickTag_end+`<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'>`+ImgTag+`</div>` 
	} else if adDetails.Type == "html" {
		if adDetails.Filename != "" {
			adDetails.Html = clickTag_start+`<iframe id='rv-h5-` + rand1 + `' name='rv-h5-` + rand1 + `' src='` + config.GetConfig("protocol","webpath") + config.GetConfig("images","webpath") + "/" + adDetails.Filename + `/index.html?CkT={CRL}'  "marginwidth='0' marginheight='0' scrolling='no'  frameborder='0' width='` + strconv.Itoa(adDetails.Width) + `' height='` + strconv.Itoa(adDetails.Width) + `' style='width: ` + strconv.Itoa(adDetails.Width) + `px; height: ` + strconv.Itoa(adDetails.Width) + `px; border: 0'></iframe>`+clickTag_end
			
			if adDeliveryType == "web" {
			adDetails.Html =adDetails.Html+` <script>  document.getElementById('rv-h5-` + rand1 + `').onload = true ? function () { var i = document.createElement('IMG');  i.src = '` + impurl2 + `';  } : null; </script><script type='text/javascript'>document.context='fHA6MQ=='; </script>`
			}
			
		} else {
			adDetails.Html = `<div>` + adDetails.Htmltemplate + `<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'>`+ImgTag+`</div></div>` 
		}
	}
	
	
	
}







func AdRenderVideoAd(adDetails *structure.AdDetails, zn structure.ZoneInfo) {
	
	 
		 
		
	clickurl := config.GetConfig( "protocol","webpath") + config.GetConfig("delivery","webpath") + "/ck.php?oaparams=2__YmFubmVyaWQ==" + strconv.Itoa(adDetails.Ad_id) + "__em9uZWlk=0__oadest=" + adDetails.Url
	impurl := config.GetConfig("protocol","webpath") + config.GetConfig("delivery","webpath") + "/lg.php?YmFubmVyaWQ==" + strconv.Itoa(adDetails.Ad_id) + "&amp;Y2FtcGFpZ25pZA===" + strconv.Itoa(adDetails.Placement_id) + "&amp;em9uZWlk=" + strconv.Itoa(zn.Zoneid) 
	table_prefix := config.GetConfig("prefix", "table")

	var sitCat_table = "djax_site_categories"
	var client_table = table_prefix + "clients"
	var campaign_table = table_prefix + "campaigns"
	var impression, pricingtype, skip, skip_progress_duration, adVerifications, Is_conditionalad, url_1, url_2, viewableImpression, trackingUrl, iabcategory, error_code, adservingid, advertiser, expiretime string
	fc_path := config.GetConfig("protocol", "webpath") + config.GetConfig("root", "webpath") + "/fc.php"
	
	vidad := structure.VideoAd{}
	
	adid_str := strconv.Itoa(adDetails.Ad_id)
	
	redisClients.GetKey("advast"+adid_str,&vidad)
	fmt.Println("vidad")
	fmt.Println(vidad)
	fmt.Println("vidad.Banner_vast_element_id")
	fmt.Println(vidad.Banner_vast_element_id)
	if vidad.Banner_vast_element_id == 0 {
		
		DbQuery := "SELECT * from " + table_prefix + "djaxbanner_vast_element where banner_id = %d"
		DbQuery = fmt.Sprintf(DbQuery, adDetails.Ad_id) 

		adVast := db.DbQueryRow(DbQuery)
		adVast.Scan(&vidad.Banner_vast_element_id, &vidad.Banner_id, &vidad.Vast_element_type, &vidad.Vast_video_id, &vidad.Vast_type, &vidad.Vast_video_duration, &vidad.Vast_video_delivery, &vidad.Get_third_internal_type, &vidad.Vast_video_type, &vidad.Vast_video_bitrate, &vidad.Vast_net_connection_url, &vidad.Vast_video_filename, &vidad.Vast_video_height, &vidad.Vast_video_width, &vidad.Vast_video_outgoing_filename, &vidad.Vast_companion_banner_id, &vidad.Vast_overlay_height, &vidad.Vast_overlay_width, &vidad.Vast_video_clickthrough_url, &vidad.Vast_overlay_action, &vidad.Vast_overlay_format, &vidad.Vast_overlay_text_title, &vidad.Vast_overlay_text_description, &vidad.Vast_overlay_text_call, &vidad.Vast_creative_type, &vidad.Vast_thirdparty_impression, &vidad.Vast_wrapper_url, &vidad.Vast_version, &vidad.Vast_overlay_wrapper, &vidad.Vast_overlay_version, &vidad.Vast_video_skip_duration, &vidad.Vast_video_skip_progress_duration, &vidad.Vast_thirdparty_clicktracking, &vidad.Vast_thirdparty_clickcustom, &vidad.Vast_overlay_expanded_width, &vidad.Vast_overlay_expanded_height, &vidad.Vast_thirdparty_companion_expandedwidth, &vidad.Vast_thirdparty_companion_expandedheight, &vidad.Vast_thirdparty_companion_clicktracking, &vidad.Vast_overlay_expandedminduration, &vidad.Vast_wrapper_followadditional, &vidad.Vast_wrapper_allowmultipleads, &vidad.Vast_wrapper_fallbacknoads, &vidad.Vast_thirdparty_companion_assetwidth, &vidad.Vast_thirdparty_companion_assetheight, &vidad.Vast_thirdparty_companion_pxratio, &vidad.Vast_thirdparty_companion_alttext, &vidad.Vast4_min_bitrate, &vidad.Vast4_max_bitrate, &vidad.Vast4_verificationurl2, &vidad.Vast4_verificationurl1, &vidad.Vast4_adverificationtype2, &vidad.Vast4_adverificationtype1, &vidad.Is_conditionalad, &vidad.Vast_icon_filename, &vidad.Vast_icon_xposition, &vidad.Vast_icon_yposition, &vidad.Vast_icon_duration, &vidad.Vast_icon_offset, &vidad.Vast_icon_height, &vidad.Vast_icon_width, &vidad.Icon_click_url, &vidad.Icon_track_url, &vidad.Iabcategory, &vidad.Vast_video_outgoing_filename1, &vidad.Vast_video_type_1, &vidad.Vast_video_bitrate_1, &vidad.Vast_video_outgoing_filename2, &vidad.Vast_video_type_2, &vidad.Vast_video_bitrate_2, &vidad.Ad_type, &vidad.Audio_type, &vidad.Interactive_mediafile, &vidad.Is_mezzininefile, &vidad.Mezzanine_en, &vidad.Internal_file, &vidad.Url_file, &vidad.Vast_4_1_url, &vidad.Vast_4_1_type_file, &vidad.Vast_4_1_language, &vidad.Vast_4_1_url_1, &vidad.Vast_4_1_type_file_1, &vidad.Vast_4_1_language_1, &vidad.Vast_4_1_url_2, &vidad.Vast_4_1_type_file_2, &vidad.Vast_4_1_language_2, &vidad.Blocked_category) 
		redisClients.SetKey("advast"+adid_str, vidad, time.Minute*5) 
	}

	trackingUrl = fc_path + "?script=djaxvideoAds:djaxvastEvent&amp;bannerid=" + strconv.Itoa(vidad.Banner_id) + "&amp;zoneid=" + strconv.Itoa(zn.Zoneid)
	adservingid = helper.RandToken(5) + strconv.Itoa(vidad.Banner_id)
	hasher := md5.New()
	hasher.Write([]byte(adservingid))
	adservingid = hex.EncodeToString(hasher.Sum(nil))

	/*Advertiser*/
	var clientid int
	var clientname string
	var clientexp time.Time
	db.DbQueryRow("select cl.clientid as clientid,cl.clientname as name,c.expire_time as expire_time from "+client_table+" as cl,"+campaign_table+" as c where c.clientid=cl.clientid and c.campaignid=?", adDetails.Placement_id).Scan(&clientid, &clientname, &clientexp)

	advertiser = `<Advertiser id="` + strconv.Itoa(clientid) + `">` + clientname + `</Advertiser>`
	/*Advertiser*/
	/*Expires*/
	if clientexp.String() != "" {
		expiretime = `<Expires>` + clientexp.String() + `</Expires>`
	}
	/*Expires*/
	/*Impression*/
	impression = `<Impression><![CDATA[` + impurl + `]]></Impression>`
		if vidad.Vast_thirdparty_impression != "" {
			impression += `<Impression><![CDATA[` + vidad.Vast_thirdparty_impression + `]]></Impression>`
		}
		/*Impression*/
		/*Error code Add*/
		error_code = `<Error><![CDATA[` + config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + `/errorcode.php?zoneid=0&amp;errorcode=[ERRORCODE]]]></Error>`
		/*Errorcode add*/
		/*Adverification for Vast4*/
		if vidad.Vast4_verificationurl1.String != "" || vidad.Vast4_verificationurl2.String != "" {
			if vidad.Vast4_verificationurl1.String == "1" {
				url_1 = `<Verification>
						<JavaScriptResource>
						<![CDATA[` + vidad.Vast4_verificationurl1.String + `]]>
						</JavaScriptResource>
					</Verification>`
			} else if vidad.Vast4_verificationurl1.String == "2" {
				url_1 = `<Verification>
						<FlashResource>
						<![CDATA[` + vidad.Vast4_verificationurl1.String + `]]>
						</FlashResource>
					</Verification>`
			}
			if vidad.Vast4_verificationurl2.String == "1" {
				url_2 = `<Verification>
							<JavaScriptResource>
							<![CDATA[` + vidad.Vast4_verificationurl2.String + `]]>
							</JavaScriptResource>
						</Verification>`
			} else if vidad.Vast4_verificationurl2.String == "2" {
				url_2 = `<Verification>
							<FlashResource>
							<![CDATA[` + vidad.Vast4_verificationurl2.String + `]]>
							</FlashResource>
						</Verification>`
			}
			if url_1 != "" || url_2 != "" {
				adVerifications = `<AdVerifications>
								` + url_1 + `
								` + url_2 + `
							</AdVerifications>`
			}
		}
		/*Adverification for Vast4*/

		/*Viewable Impression*/
		viewableImpression = `<ViewableImpression id="` + strconv.Itoa(helper.RandNumber(10)) + `">
								<Viewable><![CDATA[` + trackingUrl + `&amp;event=viewable]]></Viewable>
								<NotViewable><![CDATA[` + trackingUrl + `&amp;event=notviewable]]></NotViewable>
								<ViewUndetermined><![CDATA[` + trackingUrl + `&amp;event=viewundetermined]]></ViewUndetermined>
							</ViewableImpression>`
		/*Viewable Impression*/

		/*IAB Category in vast response*/
		if vidad.Iabcategory.String != "" {
			category := strings.Split(vidad.Iabcategory.String, ",")
			for _, v := range category {
				var cname string
				db.DbQueryRow("SELECT category_name FROM `" + sitCat_table + "` where value = '" + v + "'").Scan(&cname)
				iabcategory += `<Category authority='http://www.iabtechlab.com/categoryauthority'><![CDATA[` + cname + `]]></Category>`
			}
		}
		/*IAB Category in vast response*/

		/* Pricingtype */
		/* if vidad.Revenue_type == 1 {
			pricingtype = "CPM"
		} else if vidad.Revenue_type == 2 {
			pricingtype = "CPC"
		} else if vidad.Revenue_type == 3 {
			pricingtype = "CPA"
		} */
		pricingtype = "CPM"
		/* Pricingtype */

		/*Is_conditionalad*/
		if vidad.Is_conditionalad == 1 {
			Is_conditionalad = "true"
		} else {
			Is_conditionalad = "false"
		}
		/*Is_conditionalad*/
		/*Skip*/
		if vidad.Vast_video_skip_duration.String != "" {
			skip = `skipoffset="` + vidad.Vast_video_skip_duration.String + `"`
		}
		/*Skip*/
		/*Skip Progress*/
		if vidad.Vast_video_skip_progress_duration.String != "" {
			skip_progress_duration = `offset="` + vidad.Vast_video_skip_progress_duration.String + `"`
		} else {
			skip_progress_duration = ""
		}
		/*Skip Progress*/
		if adDetails.Width == -3 && adDetails.Height == -3 {

			var mediafile, mediafile1, mediafile2, maxbitrate, minbitrate, videoClickstrackVast, videocustomClicksVast, videoClicksVast, interactivemediafile, Mezzaninefile, icon, icontype1, resource, iprog, pricing, adType, closedcaption, closedcaption2, closedcaption3, type1, type2, type3, lang, lang1, lang2, companions, companionresource, companionclicks, companionassetheight, companionassetwidth, companionexpandedheight, companionexpandedwidth string

			/*<Clickthrough_url>*/
			if vidad.Vast_video_clickthrough_url.String != "" {
				if vidad.Vast_thirdparty_clicktracking.String != "" {
					videoClickstrackVast = `<ClickTracking><![CDATA[` + vidad.Vast_thirdparty_clicktracking.String + `]]></ClickTracking>`
				}
				if vidad.Vast_thirdparty_clickcustom.String != "" {
					videocustomClicksVast = `<CustomClick><![CDATA[` + vidad.Vast_thirdparty_clickcustom.String + `]]></CustomClick >`
				}
				videoClicksVast = `<VideoClicks>
									<ClickThrough><![CDATA[` + clickurl + `]]></ClickThrough> ` + videoClickstrackVast + videocustomClicksVast + `
								</VideoClicks>`
			}
			/*<Clickthrough_url>*/

			/*<InteractiveCreativeFile>*/
			if vidad.Interactive_mediafile != "" {
				interactivemediafile = `<InteractiveCreativeFile><![CDATA[` + vidad.Interactive_mediafile + `]]></InteractiveCreativeFile>`
			}
			/*<InteractiveCreativeFile>*/

			/*<Mezzanine>*/
			if vidad.Is_mezzininefile == 1 {
				if vidad.Mezzanine_en == 1 && vidad.Internal_file != "" {
					Videofilepath := config.GetConfig("protocol", "webpath") + config.GetConfig("protocol", "admin") + "/assets/transcoded_video/" + vidad.Internal_file
					Mezzaninefile = `<Mezzanine><![CDATA[` + Videofilepath + `]]></Mezzanine>`
				} else if vidad.Mezzanine_en == 2 {
					Mezzaninefile = `<Mezzanine><![CDATA[` + vidad.Url_file + `]]></Mezzanine>`
				}
			}
			/*<Mezzanine>*/

			/*CLosed Captions*/
			if vidad.Vast_4_1_type_file == "1" || vidad.Vast_4_1_type_file_1 == "1" || vidad.Vast_4_1_type_file_2 == "1" {
				type1 = "text/srt"
			} else if vidad.Vast_4_1_type_file == "2" || vidad.Vast_4_1_type_file_1 == "2" || vidad.Vast_4_1_type_file_2 == "2" {
				type2 = "text/vtt"
			} else if vidad.Vast_4_1_type_file == "3" || vidad.Vast_4_1_type_file_1 == "3" || vidad.Vast_4_1_type_file_2 == "3" {
				type3 = "application/ttml+xml"
			}
			if vidad.Vast_4_1_language == "1" || vidad.Vast_4_1_language_1 == "1" || vidad.Vast_4_1_language_2 == "1" {
				lang = "en"
			} else if vidad.Vast_4_1_language == "2" || vidad.Vast_4_1_language_1 == "2" || vidad.Vast_4_1_language_2 == "2" {
				lang1 = "zh-TW"
			} else if vidad.Vast_4_1_language == "3" || vidad.Vast_4_1_language_1 == "3" || vidad.Vast_4_1_language_2 == "3" {
				lang2 = "zh-CH"
			}
			if vidad.Vast_4_1_url != "" {
				if vidad.Vast_4_1_url_1 != "" {
					closedcaption2 = `<ClosedCaptionFile type='` + type2 + `' language='` + lang1 + `'><![CDATA[` + vidad.Vast_4_1_url_1 + `]]></ClosedCaptionFile>`
				}
				if vidad.Vast_4_1_url_2 != "" {
					closedcaption3 = `<ClosedCaptionFile type='` + type3 + `' language='` + lang2 + `'><![CDATA[` + vidad.Vast_4_1_url_2 + `]]></ClosedCaptionFile>`
				}
				closedcaption = `<ClosedCaptionFiles>
									<ClosedCaptionFile type='` + type1 + `' language='` + lang + `'><![CDATA[` + vidad.Vast_4_1_url + `]]></ClosedCaptionFile>` + closedcaption2 + closedcaption3 + `
								</ClosedCaptionFiles>`
			}
			/*CLosed Captions*/
			/*Icontype*/
			k := strings.Split(path.Base(vidad.Vast_icon_filename.String), ".")
			icontype1 = string(k[1])
			if icontype1 == "jpg" || icontype1 == "jpeg" {
				icontype1 = "image/jpeg"
			} else if icontype1 == "png" {
				icontype1 = "image/png"
			} else if icontype1 == "gif" {
				icontype1 = "Image/gif"
			} else if icontype1 == "htm" {
				icontype1 = "Image/htm"
			} else {
				icontype1 = ""
			}
			/*Icontype*/
			/*Pricing*/
			pricing = `<Pricing model="` + pricingtype + `" currency="USD"><![CDATA[10]]></Pricing>`
			/*Pricing*/

			/*Ad_type*/
			if vidad.Ad_type == 1 {
				adType = "audio"
			} else {
				adType = "video"
			}
			
			/*Ad_type*/
			/*<Icon>*/
			iprog = ""
			if vidad.Vast_icon_filename.String != "" {
				if icontype1 == "image/jpeg" {
					resource = `<StaticResource creativeType="` + icontype1 + `"><![CDATA[` + vidad.Vast_icon_filename.String + `]]></StaticResource>`
				} else {
					resource = `<HTMLResource><![CDATA[` + vidad.Vast_icon_filename.String + `]]></HTMLResource>`
				}
				icon = `<Icons>
							<Icon program="` + iprog + `" height= "` + strconv.Itoa(int(vidad.Vast_icon_height)) + `" width= "` + strconv.Itoa(int(vidad.Vast_icon_width)) + `" xPosition= "` + strconv.Itoa(int(vidad.Vast_icon_xposition.Int64)) + `" yPosition= "` + strconv.Itoa(int(vidad.Vast_icon_yposition.Int64)) + `" apiFramework="" offset= "` + vidad.Vast_icon_offset.String + `" duration= "` + vidad.Vast_icon_duration.String + `">
							` + resource + `
								<IconClicks>
									<IconClickThrough><![CDATA[` + trackingUrl + `&amp;event=iconclick]]> </IconClickThrough>
									<IconClickTracking><![CDATA[` + trackingUrl + `&amp;event=icontrack]]></IconClickTracking>
								</IconClicks>
								<IconViewTracking>
								<![CDATA[` + trackingUrl + `&amp;event=iconimpression]]>
								</IconViewTracking>
							</Icon>
						</Icons>`
			}
			/*<Icon>*/
			/*Mediafile*/
			mediafile = `<MediaFile delivery="` + vidad.Vast_video_delivery.String + `" bitrate="` + vidad.Vast_video_bitrate.String + `" width="` + strconv.Itoa(adDetails.Width) + `" height="` + strconv.Itoa(adDetails.Height) + `" ` + maxbitrate + ` ` + minbitrate + ` type="` + vidad.Vast_video_type.String + `" scalable="true" maintainAspectRatio="true"><![CDATA[ ` + vidad.Vast_video_outgoing_filename.String + ` ]]></MediaFile>`
			if vidad.Vast_video_outgoing_filename1.String != "" {
				mediafile1 = `<MediaFile delivery="` + vidad.Vast_video_delivery.String + `" bitrate="` + vidad.Vast_video_bitrate_1.String + `" width="` + strconv.Itoa(adDetails.Width) + `" height="` + strconv.Itoa(adDetails.Height) + `" ` + maxbitrate + ` ` + minbitrate + ` type="` + vidad.Vast_video_type_1.String + `" scalable="true" maintainAspectRatio="true"><![CDATA[ ` + vidad.Vast_video_outgoing_filename1.String + ` ]]></MediaFile>`
			}
			if vidad.Vast_video_outgoing_filename2.String != "" {
				mediafile2 = `<MediaFile delivery="` + vidad.Vast_video_delivery.String + `" bitrate="` + vidad.Vast_video_bitrate_2.String + `" width="` + strconv.Itoa(adDetails.Width) + `" height="` + strconv.Itoa(adDetails.Height) + `" ` + maxbitrate + ` ` + minbitrate + ` type="` + vidad.Vast_video_type_2.String + `" scalable="true" maintainAspectRatio="true"><![CDATA[ ` + vidad.Vast_video_outgoing_filename2.String + ` ]]></MediaFile>`
			}
			/*Mediafile*/
			/*Min Max Bitrate*/
			if vidad.Vast4_max_bitrate.Int64 != 0 {
				maxbitrate = `"maxBitrate="` + `"` + strconv.Itoa(int(vidad.Vast4_max_bitrate.Int64)) + `"`
			}
			if vidad.Vast4_min_bitrate.Int64 != 0 {
				minbitrate = `"minBitrate="` + `"` + strconv.Itoa(int(vidad.Vast4_min_bitrate.Int64)) + `"`
			}
			/*Min Max Bitrate*/

			/*Companion Ads*/
			if vidad.Vast_thirdparty_companion_assetwidth.Int64 != 0 {
				companionassetwidth = `assetWidth="` + strconv.Itoa(int(vidad.Vast_thirdparty_companion_assetwidth.Int64)) + `"`
			}
			if vidad.Vast_thirdparty_companion_assetheight.Int64 != 0 {
				companionassetheight = `assetHeight="` + strconv.Itoa(int(vidad.Vast_thirdparty_companion_assetheight.Int64)) + `"`
			}
			if vidad.Vast_thirdparty_companion_expandedheight != 0 {
				companionexpandedheight = `expandedHeight="` + strconv.Itoa(vidad.Vast_thirdparty_companion_expandedheight) + `"`
			}
			if vidad.Vast_thirdparty_companion_expandedwidth != 0 {
				companionexpandedwidth = `expandedWidth="` + strconv.Itoa(vidad.Vast_thirdparty_companion_expandedwidth) + `"`
			}
			if vidad.Vast_creative_type.String != ""{
				companionresource = `<StaticResource creativeType="`+ vidad.Vast_creative_type.String +`">`
			}
			if vidad.Vast_video_clickthrough_url.String != ""{
				companionclicks = `<CompanionClickThrough><![CDATA[` + vidad.Vast_thirdparty_companion_clicktracking + `]]></CompanionClickThrough>
					<CompanionClickTracking><![CDATA[` + vidad.Vast_thirdparty_companion_clicktracking + `]]></CompanionClickTracking>`
			}
			if vidad.Vast_companion_banner_id != 0 {
				companions = `<Companion id="`+ strconv.Itoa(vidad.Vast_companion_banner_id) +`"` + companionassetwidth + companionassetheight + companionexpandedwidth + companionexpandedheight + `">
				`+ companionresource +`
				`+ companionclicks +`
				</Companion>`
			}
			
			
			
			
			if vidad.Vast_type == 1 {
				if vidad.Get_third_internal_type == 1 {

					adDetails.Html = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="2.0" xsi:noNamespaceSchemaLocation="vast.xsd">
					<Ad id="` + strconv.Itoa(vidad.Banner_id) + `">
						<InLine>
							<AdSystem>
							<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
							</AdSystem>
							<AdTitle>
							<![CDATA[ ` + adDetails.Name + ` ]]>
							</AdTitle>
							` + impression + `
							<Creatives>
								<Creative>
									<Linear>
										<Duration>` + helper.SecondsToTime(int(vidad.Vast_video_duration.Int64)) + `</Duration>
										<TrackingEvents>
											<Tracking event="start">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=start
												]]>
											</Tracking>
											<Tracking event="firstQuartile">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=firstquartile
												]]>
											</Tracking>
											<Tracking event="midpoint">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=midpoint
												]]>
											</Tracking>
											<Tracking event="thirdQuartile">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=thirdquartile
												]]>
											</Tracking>
											<Tracking event="complete">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=complete
												]]>
											</Tracking>
											<Tracking event="pause">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=pause
												]]>
											</Tracking>
											<Tracking event="mute">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=mute
												]]>
											</Tracking>
											<Tracking event="fullscreen">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=fullscreen
												]]>
											</Tracking>
											<Tracking event="unmute">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=unmute
												]]>
											</Tracking>
											<Tracking event="rewind">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=rewind
												]]>
											</Tracking>
											<Tracking event="resume">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=resume
												]]>
											</Tracking>
										</TrackingEvents>
										<VideoClicks>
											<ClickThrough>
											<![CDATA[` + clickurl + `]]>
											</ClickThrough>
										</VideoClicks>
										<MediaFiles>
											` + mediafile + `
										</MediaFiles>
									</Linear>
								</Creative>													
							</Creatives>
						</InLine>
					</Ad>
				</VAST>`
				} else {
					adDetails.Html = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="2.0" xsi:noNamespaceSchemaLocation="vast.xsd">
					<Ad id="` + strconv.Itoa(vidad.Banner_id) + `">
						<Wrapper>
							<AdSystem>
							<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]></AdSystem>
							<AdTitle>
							<![CDATA[ ` + adDetails.Name + ` ]]>
							</AdTitle>
							` + impression + `
							<VASTAdTagURI><![CDATA[ ` + strings.Replace(vidad.Vast_wrapper_url, "&", "&amp;", -1) + ` ]]></VASTAdTagURI>
							<Creatives>
								<Creative>
									<Linear>
										<Duration>` + helper.SecondsToTime(int(vidad.Vast_video_duration.Int64)) + `</Duration>
										<TrackingEvents>
											<Tracking event="start">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=start
											]]>
											</Tracking>
											<Tracking event="firstQuartile">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=firstquartile
											]]>
											</Tracking>
											<Tracking event="midpoint">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=midpoint
											]]>
											</Tracking>
											<Tracking event="thirdQuartile">
											<![CDATA[
												` + fc_path + `script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=thirdquartile
											]]>
											</Tracking>
											<Tracking event="complete">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=complete
											]]>
											</Tracking>
											<Tracking event="pause">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=pause
											]]>
											</Tracking>
											<Tracking event="mute">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=mute
											]]>
											</Tracking>
											<Tracking event="fullscreen">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=fullscreen
											]]>
											</Tracking>
											<Tracking event="unmute">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=unmute
											]]>
											</Tracking>
											<Tracking event="rewind">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=rewind
											]]>
											</Tracking>
											<Tracking event="resume">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=resume
											]]>
											</Tracking>
										</TrackingEvents>
										<VideoClicks>
											<ClickThrough>
											<![CDATA[` + clickurl + `]]>
											</ClickThrough>
										</VideoClicks>
									</Linear>
								</Creative>
							</Creatives>
						</Wrapper>
					</Ad>
				</VAST>`
				}
			} else if vidad.Vast_type == 2 {

				if vidad.Get_third_internal_type == 1 {
					adDetails.Html = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="3.0" xsi:noNamespaceSchemaLocation="vast.xsd">
					<Ad id="` + strconv.Itoa(vidad.Banner_id) + `">
						<InLine>
							<AdSystem>
							<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
							</AdSystem>
							<AdTitle>
							<![CDATA[ ` + adDetails.Name + ` ]]>
							</AdTitle>
							<Pricing>
								<model>
								<![CDATA[ ` + pricingtype + ` ]]>
								</model>
								<currency>
								<![CDATA[ USD ]]>
								</currency>
							</Pricing>
							` + impression + `
							<Creatives>
								<Creative>
									<Linear ` + skip + `>
										<Duration>` + helper.SecondsToTime(int(vidad.Vast_video_duration.Int64)) + `</Duration>
										<TrackingEvents>
											<Tracking event="start">
											<![CDATA[
											` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=start
												]]>
											</Tracking>
											<Tracking event="firstQuartile">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=firstquartile
												]]>
											</Tracking>
											<Tracking event="midpoint">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=midpoint
												]]>
											</Tracking>
											<Tracking event="thirdQuartile">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=thirdquartile
												]]>
											</Tracking>
											<Tracking event="complete">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=complete
												]]>
											</Tracking>
											<Tracking event="pause">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=pause
												]]>
											</Tracking>
											<Tracking event="mute">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=mute
												]]>
											</Tracking>
											<Tracking event="fullscreen">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=fullscreen
												]]>
											</Tracking>
											<Tracking event="unmute">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=unmute
												]]>
											</Tracking>
											<Tracking event="closeLinear">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=closeLinear
												]]>
											</Tracking>
											<Tracking event="acceptInvitationLinear">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=acceptInvitationLinear
												]]>
											</Tracking>
											<Tracking event="skip">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=skip
												]]>
											</Tracking>
											<Tracking event="progress" ` + skip_progress_duration + `>
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=progress
												]]>
											</Tracking>
											<Tracking event="exitFullscreen">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=exitfullscreen
												]]>
											</Tracking>
											<Tracking event="rewind">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=rewind
												]]>
											</Tracking>
											<Tracking event="resume">
											<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=resume
												]]>
											</Tracking>
										</TrackingEvents>
										` + videoClicksVast + `
										<MediaFiles>
											` + mediafile + `
										</MediaFiles>
									</Linear>
								</Creative>
							</Creatives>
						</InLine>
					</Ad>
				</VAST>`
				} else {
					adDetails.Html = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="3.0" xsi:noNamespaceSchemaLocation="vast.xsd">
					<Ad id="` + strconv.Itoa(vidad.Banner_id) + `">
						<Wrapper>
							<AdSystem>
							<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
							</AdSystem>
							<AdTitle>
							<![CDATA[ ` + adDetails.Name + ` ]]>
							</AdTitle>
							<Pricing>
								<model>
								<![CDATA[ ` + pricingtype + ` ]]>
								</model>
								<currency>
								<![CDATA[ USD ]]>
								</currency>
							</Pricing>
							` + impression + `
							<VASTAdTagURI>
							<![CDATA[ ` + strings.Replace(vidad.Vast_wrapper_url, "&", "&amp;", -1) + ` ]]>
							</VASTAdTagURI>
							<Creatives>
								<Creative>
									<Linear>
										<Duration>` + helper.SecondsToTime(int(vidad.Vast_video_duration.Int64)) + `</Duration>
										<TrackingEvents>
											<Tracking event="start">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=start
											]]>
											</Tracking>
											<Tracking event="firstQuartile">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=firstquartile
											]]>
											</Tracking>
											<Tracking event="midpoint">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=midpoint
											]]>
											</Tracking>
											<Tracking event="thirdQuartile">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=thirdquartile
											]]>
											</Tracking>
											<Tracking event="complete">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=complete
											]]>
											</Tracking>
											<Tracking event="pause">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=pause
											]]>
											</Tracking>
											<Tracking event="mute">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=mute
											]]>
											</Tracking>
											<Tracking event="fullscreen">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=fullscreen
											]]>
											</Tracking>
											<Tracking event="unmute">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=unmute
											]]>
											</Tracking>
											<Tracking event="acceptInvitationLinear">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=acceptInvitationLinear
											]]>
											</Tracking>
											<Tracking event="closeLinear">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=closeLinear
											]]>
											</Tracking>
											<Tracking event="skip">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=skip
											]]>
											</Tracking>
											<Tracking event="progress">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=progress
											]]>
											</Tracking>
											<Tracking event="exitFullscreen">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=exitfullscreen
											]]>
											</Tracking>
											<Tracking event="rewind">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=rewind
											]]>
											</Tracking>
											<Tracking event="resume">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=resume
											]]>
											</Tracking>
										</TrackingEvents>
										` + videoClicksVast + `
									</Linear>
								</Creative>
							</Creatives>
						</Wrapper>
					</Ad>
				</VAST>`
				}
			} else if vidad.Vast_type == 3 {
				if vidad.Get_third_internal_type == 1 {
					adDetails.Html = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.0" xsi:noNamespaceSchemaLocation="vast.xsd">
					<Ad id="` + strconv.Itoa(vidad.Banner_id) + `" conditionalAd="` + Is_conditionalad + `">
						<InLine>
							<AdSystem version="4.0">
							<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
							</AdSystem>
							` + error_code + `
							<AdTitle>
							<![CDATA[ ` + adDetails.Name + ` ]]>
							</AdTitle>
							` + adVerifications + `
							` + viewableImpression + `
							` + iabcategory + `
							` + pricing + `
							` + impression + `
							<Creatives>
								<Creative>
									<UniversalAdId idRegistry="unknown" idValue="unknown">unknown</UniversalAdId>
									<Linear ` + skip + `>
										<Duration>` + helper.SecondsToTime(int(vidad.Vast_video_duration.Int64)) + `</Duration>
										<TrackingEvents>
											<Tracking event="start">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=start
											]]>
											</Tracking>
											<Tracking event="firstQuartile">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;zoneid=0&amp;event=firstquartile
											]]>
											</Tracking>
											<Tracking event="midpoint">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;zoneid=0&amp;event=midpoint
											]]>
											</Tracking>
											<Tracking event="thirdQuartile">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;zoneid=0&amp;event=thirdquartile
											]]>
											</Tracking>
											<Tracking event="complete">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;zoneid=0&amp;event=complete
											]]>
											</Tracking>
											<Tracking event="pause">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;zoneid=0&amp;event=pause
											]]>
											</Tracking>
											<Tracking event="mute">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;zoneid=0&amp;event=mute
											]]>
											</Tracking>
											<Tracking event="unmute">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;zoneid=0&amp;event=unmute
											]]>
											</Tracking>
											<Tracking event="acceptInvitationLinear">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;zoneid=0&amp;event=acceptInvitationLinear
											]]>
											</Tracking>
											<Tracking event="skip">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;zoneid=0&amp;event=skip
											]]>
											</Tracking>
											<Tracking event="progress" ` + skip_progress_duration + `>
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;zoneid=0&amp;event=progress
											]]>
											</Tracking>
											<Tracking event="rewind">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;zoneid=0&amp;event=rewind
											]]>
											</Tracking>
											<Tracking event="resume">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;zoneid=0&amp;event=resume
											]]>
											</Tracking>
											<Tracking event="timeSpentViewing">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;zoneid=0&amp;event=timeSpentViewing
											]]>
											</Tracking>
											<Tracking event="otherAdInteraction">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;zoneid=0&amp;event=otherAdInteraction
											]]>
											</Tracking>
											<Tracking event="playerExpand">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;zoneid=0&amp;event=playerExpand
											]]>
											</Tracking>
											<Tracking event="playerCollapse">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;zoneid=0&amp;event=playerCollapse
											]]>
											</Tracking>
										</TrackingEvents>
										` + videoClicksVast + `
										<MediaFiles>
											` + mediafile + `
											` + mediafile1 + `
											` + mediafile2 + `
											` + interactivemediafile + `
											` + Mezzaninefile + `
										</MediaFiles>
										` + icon + `
									</Linear>
								</Creative>
							</Creatives>
						</InLine>
					</Ad>
				</VAST>`
				} else {
					adDetails.Html = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.0" xsi:noNamespaceSchemaLocation="vast.xsd">
					<Ad id="` + strconv.Itoa(vidad.Banner_id) + `" conditionalAd="` + Is_conditionalad + `">
						<Wrapper fallbackOnNoAd="` + strconv.Itoa(vidad.Vast_wrapper_fallbacknoads) + `" allowMultipleAds="` + strconv.Itoa(vidad.Vast_wrapper_allowmultipleads) + `" followAdditionalWrappers="` + strconv.Itoa(vidad.Vast_wrapper_followadditional) + `">
							<AdSystem version="4.0">
							<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
							</AdSystem>
							` + error_code + `
							` + viewableImpression + `
							` + pricing + `
							` + impression + `
							<VASTAdTagURI>
							<![CDATA[ ` + strings.Replace(vidad.Vast_wrapper_url, "&", "&amp;", -1) + ` ]]>
							</VASTAdTagURI>
							<Creatives>
								<Creative>
									<Linear>
										<TrackingEvents>
											<Tracking event="start">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=start
											]]>
											</Tracking>
											<Tracking event="firstQuartile">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=firstquartile
											]]>
											</Tracking>
											<Tracking event="midpoint">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=midpoint
											]]>
											</Tracking>
											<Tracking event="thirdQuartile">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=thirdquartile
											]]>
											</Tracking>
											<Tracking event="complete">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=complete
											]]>
											</Tracking>
											<Tracking event="pause">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=pause
											]]>
											</Tracking>
											<Tracking event="mute">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=mute
											]]>
											</Tracking>
											<Tracking event="unmute">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=unmute
											]]>
											</Tracking>
											<Tracking event="acceptInvitationLinear">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=acceptInvitationLinear
											]]>
											</Tracking>
											<Tracking event="skip">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=skip
											]]>
											</Tracking>
											<Tracking event="progress">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=progress
											]]>
											</Tracking>
											<Tracking event="rewind">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=rewind
											]]>
											</Tracking>
											<Tracking event="resume">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=resume
											]]>
											</Tracking>
											<Tracking event="timeSpentViewing">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=timeSpentViewing
											]]>
											</Tracking>
											<Tracking event="otherAdInteraction">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=otherAdInteraction
											]]>
											</Tracking>
											<Tracking event="playerExpand">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=playerExpand
											]]>
											</Tracking>
											<Tracking event="playerCollapse">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=playerCollapse
											]]>
											</Tracking>
										</TrackingEvents>
										` + videoClicksVast + `
										` + icon + `
									</Linear>
								</Creative>
							</Creatives>
						</Wrapper>
					</Ad>
				</VAST>`
				}
			} else {
				if  vidad.Ad_type == 2{
					if vidad.Get_third_internal_type == 1{
						adDetails.Html = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.1" xsi:noNamespaceSchemaLocation="vast.xsd">
							<Ad id="` + strconv.Itoa(vidad.Banner_id) + `"  adType="` + adType + `">
								<InLine>
									<AdSystem version="4.1">
									<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
									</AdSystem>
									<AdServingId>` + adservingid + `</AdServingId>
									` + advertiser + `
									<Description>` + adDetails.Name + `</Description>
									` + expiretime + `
									` + error_code + `
									<AdTitle>
									<![CDATA[ ` + adDetails.Name + ` ]]>
									</AdTitle>
									` + adVerifications + `
									` + viewableImpression + `
									` + iabcategory + `
									` + pricing + `
									` + impression + `
									<Creatives>
										<Creative>
											<UniversalAdId idRegistry="unknown" idValue="unknown">unknown</UniversalAdId>
											<Linear ` + skip + `>
												<Duration>` +helper.SecondsToTime(int(vidad.Vast_video_duration.Int64)) + `</Duration>
												<TrackingEvents>
													<Tracking event="start">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=start
													]]>
													</Tracking>
													<Tracking event="firstQuartile">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=firstquartile
													]]>
													</Tracking>
													<Tracking event="midpoint">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=midpoint
													]]>
													</Tracking>
													<Tracking event="thirdQuartile">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=thirdquartile
													]]>
													</Tracking>
													<Tracking event="complete">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=complete
													]]>
													</Tracking>
													<Tracking event="pause">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=pause
													]]>
													</Tracking>
													<Tracking event="mute">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=mute
													]]>
													</Tracking>
													<Tracking event="unmute">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=unmute
													]]>
													</Tracking>
													<Tracking event="acceptInvitationLinear">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=acceptInvitationLinear
													]]>
													</Tracking>
													<Tracking event="skip">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=skip
													]]>
													</Tracking>
													<Tracking event="progress" ` + skip_progress_duration + `>
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=progress
													]]>
													</Tracking>
													<Tracking event="rewind">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=rewind
													]]>
													</Tracking>
													<Tracking event="resume">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=resume
													]]>
													</Tracking>
													<Tracking event="timeSpentViewing">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=timeSpentViewing
													]]>
													</Tracking>
													<Tracking event="otherAdInteraction">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=otherAdInteraction
													]]>
													</Tracking>
													<Tracking event="playerExpand">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=playerExpand
													]]>
													</Tracking>
													<Tracking event="playerCollapse">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=playerCollapse
													]]>
													</Tracking>
												</TrackingEvents>
												` + videoClicksVast + `
												<MediaFiles>
													` + closedcaption + `
													` + mediafile + `
													` + mediafile1 + `
													` + mediafile2 + `
													` + interactivemediafile + `
													` + Mezzaninefile + `
												</MediaFiles>
												` + icon + `
											</Linear>
										</Creative>
									</Creatives>
								</InLine>
							</Ad>
						</VAST>`
					}else{
						adDetails.Html = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.1" xsi:noNamespaceSchemaLocation="vast.xsd">
							<Ad id="` + strconv.Itoa(vidad.Banner_id) + `" conditionalAd="` + Is_conditionalad + `">
								<Wrapper fallbackOnNoAd="` + strconv.Itoa(vidad.Vast_wrapper_fallbacknoads) + `" allowMultipleAds="` + strconv.Itoa(vidad.Vast_wrapper_allowmultipleads) + `" followAdditionalWrappers="` + strconv.Itoa(vidad.Vast_wrapper_followadditional) + `">
									<AdSystem version="4.1">
									<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
									</AdSystem>
									<AdServingId>` + adservingid + `</AdServingId>
									` + advertiser + `
									<Description>` + adDetails.Name + `</Description>
									` + expiretime + `
									` + viewableImpression + `
									` + pricing + `
									` + impression + `
									<VASTAdTagURI>
									<![CDATA[ ` + strings.Replace(vidad.Vast_wrapper_url, "&", "&amp;", -1) + ` ]]>
									</VASTAdTagURI>
									<Creatives>
										<Creative>
											<Linear>
												<TrackingEvents>
													<Tracking event="start">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=start
													]]>
													</Tracking>
													<Tracking event="firstQuartile">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=firstquartile
													]]>
													</Tracking>
													<Tracking event="midpoint">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=midpoint
													]]>
													</Tracking>
													<Tracking event="thirdQuartile">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=thirdquartile
													]]>
													</Tracking>
													<Tracking event="complete">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=complete
													]]>
													</Tracking>
													<Tracking event="pause">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=pause
													]]>
													</Tracking>
													<Tracking event="mute">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=mute
													]]>
													</Tracking>
													<Tracking event="unmute">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=unmute
													]]>
													</Tracking>
													<Tracking event="acceptInvitationLinear">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=acceptInvitationLinear
													]]>
													</Tracking>
													<Tracking event="skip">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=skip
													]]>
													</Tracking>
													<Tracking event="progress">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=progress
													]]>
													</Tracking>
													<Tracking event="rewind">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=rewind
													]]>
													</Tracking>
													<Tracking event="resume">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=resume
													]]>
													</Tracking>
													<Tracking event="timeSpentViewing">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=timeSpentViewing
													]]>
													</Tracking>
													<Tracking event="otherAdInteraction">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=otherAdInteraction
													]]>
													</Tracking>
													<Tracking event="playerExpand">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=playerExpand
													]]>
													</Tracking>
													<Tracking event="playerCollapse">
													<![CDATA[
														` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=playerCollapse
													]]>
													</Tracking>
												</TrackingEvents>
												` + videoClicksVast + `
												` + icon + `
											</Linear>
										</Creative>
									</Creatives>
								</Wrapper>
							</Ad>
						</VAST>`					
					}
					
				}else if vidad.Get_third_internal_type == 1 && vidad.Ad_type == 1{
					adDetails.Html = `<DAAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.1" xsi:noNamespaceSchemaLocation="vast.xsd">
					<Ad id="` + strconv.Itoa(vidad.Banner_id) + `"  adType="` + adType + `">
						<InLine>
							<AdSystem version="4.1">
							<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
							</AdSystem>
							<AdServingId>` + adservingid + `</AdServingId>
							` + advertiser + `
							<Description>` + adDetails.Name + `</Description>
							` + expiretime + `
							` + error_code + `
							<AdTitle>
							<![CDATA[ ` + adDetails.Name + ` ]]>
							</AdTitle>
							` + adVerifications + `
							` + viewableImpression + `
							` + iabcategory + `
							` + pricing + `
							` + impression + `
							<Creatives>
								<Creative>
									<UniversalAdId idRegistry="unknown" idValue="unknown">unknown</UniversalAdId>
									<Linear ` + skip + `>
										<Duration>` +helper.SecondsToTime(int(vidad.Vast_video_duration.Int64)) + `</Duration>
										<TrackingEvents>
											<Tracking event="start">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=start
											]]>
											</Tracking>
											<Tracking event="firstQuartile">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=firstquartile
											]]>
											</Tracking>
											<Tracking event="midpoint">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=midpoint
											]]>
											</Tracking>
											<Tracking event="thirdQuartile">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=thirdquartile
											]]>
											</Tracking>
											<Tracking event="complete">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=complete
											]]>
											</Tracking>
											<Tracking event="pause">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=pause
											]]>
											</Tracking>
											<Tracking event="mute">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=mute
											]]>
											</Tracking>
											<Tracking event="unmute">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=unmute
											]]>
											</Tracking>
											<Tracking event="acceptInvitationLinear">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=acceptInvitationLinear
											]]>
											</Tracking>
											<Tracking event="skip">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=skip
											]]>
											</Tracking>
											<Tracking event="progress" ` + skip_progress_duration + `>
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=progress
											]]>
											</Tracking>
											<Tracking event="rewind">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=rewind
											]]>
											</Tracking>
											<Tracking event="resume">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=resume
											]]>
											</Tracking>
											<Tracking event="timeSpentViewing">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=timeSpentViewing
											]]>
											</Tracking>
											<Tracking event="otherAdInteraction">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=otherAdInteraction
											]]>
											</Tracking>
											<Tracking event="playerExpand">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=playerExpand
											]]>
											</Tracking>
											<Tracking event="playerCollapse">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=playerCollapse
											]]>
											</Tracking>
										</TrackingEvents>
										<AudioInteractions>
											<ClickThrough><![CDATA[` + clickurl + `]]></ClickThrough> 
											` + videoClickstrackVast + videocustomClicksVast + `
										</AudioInteractions>
										<MediaFiles>
											` + mediafile + `
											` + mediafile1 + `
											` + mediafile2 + `
											` + interactivemediafile + `
											` + Mezzaninefile + `
										</MediaFiles>
										` + icon + `
									</Linear>
								</Creative>
							</Creatives>
							<CompanionAds>
								`+ companions +`			
							</CompanionAds>
						</InLine>
					</Ad>
				</DAAST>`
				} else {
					adDetails.Html = `<DAAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.1" xsi:noNamespaceSchemaLocation="vast.xsd">
					<Ad id="` + strconv.Itoa(vidad.Banner_id) + `"  adType="` + adType + `">
						<Wrapper>
							<AdSystem version="4.1">
							<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
							</AdSystem>
							<AdServingId>` + adservingid + `</AdServingId>
							` + advertiser + `
							<Description>` + adDetails.Name + `</Description>
							` + expiretime + `
							` + error_code + `
							<AdTitle>
							<![CDATA[ ` + adDetails.Name + ` ]]>
							</AdTitle>
							` + adVerifications + `
							` + viewableImpression + `
							` + iabcategory + `
							` + pricing + `
							` + impression + `
							<Creatives>
								<Creative>
									<UniversalAdId idRegistry="unknown" idValue="unknown">unknown</UniversalAdId>
									<Linear ` + skip + `>
										<Duration>` +helper.SecondsToTime(int(vidad.Vast_video_duration.Int64)) + `</Duration>
										<TrackingEvents>
											<Tracking event="start">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=start
											]]>
											</Tracking>
											<Tracking event="firstQuartile">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=firstquartile
											]]>
											</Tracking>
											<Tracking event="midpoint">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=midpoint
											]]>
											</Tracking>
											<Tracking event="thirdQuartile">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=thirdquartile
											]]>
											</Tracking>
											<Tracking event="complete">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=complete
											]]>
											</Tracking>
											<Tracking event="pause">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=pause
											]]>
											</Tracking>
											<Tracking event="mute">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=mute
											]]>
											</Tracking>
											<Tracking event="unmute">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=unmute
											]]>
											</Tracking>
											<Tracking event="acceptInvitationLinear">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=acceptInvitationLinear
											]]>
											</Tracking>
											<Tracking event="skip">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=skip
											]]>
											</Tracking>
											<Tracking event="progress" ` + skip_progress_duration + `>
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=progress
											]]>
											</Tracking>
											<Tracking event="rewind">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=rewind
											]]>
											</Tracking>
											<Tracking event="resume">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=resume
											]]>
											</Tracking>
											<Tracking event="timeSpentViewing">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=timeSpentViewing
											]]>
											</Tracking>
											<Tracking event="otherAdInteraction">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=otherAdInteraction
											]]>
											</Tracking>
											<Tracking event="playerExpand">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=playerExpand
											]]>
											</Tracking>
											<Tracking event="playerCollapse">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&amp;bannerid=` + strconv.Itoa(vidad.Banner_id) + `&amp;zoneid=` + strconv.Itoa(zn.Zoneid) + `&amp;event=playerCollapse
											]]>
											</Tracking>
										</TrackingEvents>
										<AudioInteractions>
											<ClickThrough><![CDATA[` + clickurl + `]]></ClickThrough> 
											` + videoClickstrackVast + videocustomClicksVast + `
										</AudioInteractions>
										<MediaFiles>
											` + mediafile + `
											` + mediafile1 + `
											` + mediafile2 + `
											` + interactivemediafile + `
											` + Mezzaninefile + `
										</MediaFiles>
										` + icon + `
									</Linear>
								</Creative>
							</Creatives>
							<CompanionAds>
								`+ companions +`			
							</CompanionAds>
						</Wrapper>
					</Ad>
				</DAAST>`
				}
			}
		} else if adDetails.Width == -2 && adDetails.Height == -2 {
			var creativeType, oclickurl, nonLinearClickThrough, nonLinearClickTracking, creativeTypeAttribute, expand_width, expand_height, expand_duration, nonLinear, vpaid_swf, resourceType, elementName, code string
			//~ fmt.Println(nonLinear)
			creativeType = vidad.Vast_creative_type.String
			if vidad.Vast_overlay_format.String == "image_overlay" {
				if creativeType == "" {
					s := adDetails.Filename
					creativeType = s[len(s)-3:]
					if creativeType == "peg" {
						creativeType = "jpeg"
					}
				}
				if creativeType == "jpeg" {
					creativeType = "jpg"
				}
				creativeType = "image/" + creativeType
				code = config.GetConfig("protocol", "webpath") + config.GetConfig("images", "webpath") + "/" + adDetails.Filename
				resourceType = "static"
				elementName = "StaticResource"
			}
			if adDetails.Url != "" {
				oclickurl = config.GetConfig("protocol", "webpath") + config.GetConfig("host", "app") + config.GetConfig("port", "app") +"?/ck?bannerid=" + strconv.Itoa(vidad.Banner_id) + "&amp;zoneid=" + strconv.Itoa(zn.Zoneid) + "&oadest=" + adDetails.Url + "&campaignid=" + strconv.Itoa(adDetails.Placement_id)
			}
			
			if oclickurl != "" {
				nonLinearClickThrough = `<NonLinearClickThrough>
												<![CDATA[` + oclickurl + `]]>
											</NonLinearClickThrough>`
			}
			if vidad.Vast_thirdparty_clicktracking.String != "" {
				nonLinearClickTracking = `<NonLinearClickTracking>
												<![CDATA[` + vidad.Vast_thirdparty_clicktracking.String + `]]>
											</NonLinearClickTracking>`
			}
			if creativeType != "" {
				creativeType = strings.ToLower(creativeType)
				creativeTypeAttribute = `creativeType="` + creativeType + `"`
			}
			if vidad.Vast_overlay_expanded_width.Int64 != 0 {
				expand_width = `expandedWidth="` + strconv.Itoa(int(vidad.Vast_overlay_expanded_width.Int64)) + `"`
			}
			if vidad.Vast_overlay_expanded_height.Int64 != 0 {
				expand_height = `expandedHeight="` + strconv.Itoa(int(vidad.Vast_overlay_expanded_height.Int64)) + `"`
			}
			if vidad.Vast_overlay_expandedminduration.String != "" {
				expand_duration = `minSuggestedDuration="` + vidad.Vast_overlay_expandedminduration.String + `"`
			}
			/*nonLinear*/
			if resourceType == "static" {
				nonLinear = `<NonLinear id="overlay" width="` + strconv.Itoa(int(vidad.Vast_overlay_width.Int64)) + `" height="` + strconv.Itoa(int(vidad.Vast_overlay_height.Int64)) + `" maintainAspectRatio="true" ` + vpaid_swf + ` scalable="true" ` + expand_duration + ` ` + expand_width + ` ` + expand_height + `><` + elementName + ` ` + creativeTypeAttribute + `>
									<![CDATA[` + code + `]]></` + elementName + `>
									` + nonLinearClickThrough + `
									` + nonLinearClickTracking + `
								</NonLinear>`
			} else {
				nonLinear = `<NonLinear id="overlay">
									` + nonLinearClickThrough + `
									` + nonLinearClickTracking + `
								</NonLinear>`
			}
			/*nonLinear*/
			if vidad.Vast_type == 1 {
				if vidad.Vast_overlay_format.String == "image_overlay" {
					adDetails.Html = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="2.0" xsi:noNamespaceSchemaLocation="vast.xsd">
									<Ad id="` + strconv.Itoa(vidad.Banner_id) + `">
										<InLine>
											<AdSystem>
												<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
											</AdSystem>
											<AdTitle>
												<![CDATA[ ` + adDetails.Name + ` ]]>
											</AdTitle>
											` + impression + `
											<Creatives>
												<Creative sequence="1">
													<NonLinearAds>
														<TrackingEvents>
															<Tracking event="creativeView">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=creativeView
															]]>
															</Tracking>
															<Tracking event="expand">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=expand
															]]>
															</Tracking>
															<Tracking event="collapse">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=collapse
															]]>
															</Tracking>
															<Tracking event="acceptInvitation">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=acceptInvitation
															]]>
															</Tracking>
															<Tracking event="close">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=close
															]]>
															</Tracking>
														</TrackingEvents>
														` + nonLinear + `
													</NonLinearAds>
												</Creative>
											</Creatives>
										</InLine>
									</Ad>
								</VAST>`
				} else {
					adDetails.Html = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="2.0" xsi:noNamespaceSchemaLocation="vast.xsd">
					<Ad id="` + strconv.Itoa(vidad.Banner_id) + `">
						<Wrapper>
							<AdSystem>
								<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
							</AdSystem>
							<AdTitle>
								<![CDATA[ ` + adDetails.Name + ` ]]>
							</AdTitle>
							` + impression + `
							<VASTAdTagURI>
								<![CDATA[ ` + strings.Replace(vidad.Vast_overlay_wrapper.String, "&", "&amp;", -1) + ` ]]>
							</VASTAdTagURI>
							<Creatives>
								<Creative sequence="1">
									<NonLinearAds>
										<TrackingEvents>
											<Tracking event="creativeView">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=creativeView
											]]>
											</Tracking>
											<Tracking event="expand">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=expand
											]]>
											</Tracking>
											<Tracking event="collapse">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=collapse
											]]>
											</Tracking>
											<Tracking event="acceptInvitation">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=acceptInvitation
											]]>
											</Tracking>
											<Tracking event="close">
											<![CDATA[
												` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=close
											]]>
											</Tracking>
										</TrackingEvents>
										` + nonLinear + `
									</NonLinearAds>
								</Creative>
							</Creatives>
						</Wrapper>
					</Ad>
				</VAST>`
				}
			} else if vidad.Vast_type == 2 {
				if vidad.Vast_overlay_format.String == "image_overlay" {
					adDetails.Html = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="3.0" xsi:noNamespaceSchemaLocation="vast.xsd">
					<Ad id="` + strconv.Itoa(vidad.Banner_id) + `">
						<InLine>
							<AdSystem>
								<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
							</AdSystem>
							<AdTitle>
								<![CDATA[ ` + adDetails.Name + ` ]]>
							</AdTitle>
							<Pricing>
								<model>
									<![CDATA[ ` + pricingtype + ` ]]>
								</model>
								<currency>
									<![CDATA[ USD ]]>
								</currency>
							</Pricing>
							` + impression + `											
							<Creatives>
								<Creative sequence="1">
									<NonLinearAds>
										<TrackingEvents>
											<Tracking event="creativeView">
												<![CDATA[
													` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=creativeView
												]]>
											</Tracking>
											<Tracking event="expand">
												<![CDATA[
													` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=expand
												]]>
											</Tracking>
											<Tracking event="collapse">
												<![CDATA[
													` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=collapse
												]]>
											</Tracking>
										</TrackingEvents>
										` + nonLinear + `
									</NonLinearAds>
								</Creative>
							</Creatives>
						</InLine>
					</Ad>
				</VAST>`
				} else {
					adDetails.Html = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="3.0" xsi:noNamespaceSchemaLocation="vast.xsd">
									<Ad id="` + strconv.Itoa(vidad.Banner_id) + `">
									<Wrapper>
										<AdSystem>
											<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
										</AdSystem>
										<AdTitle>
											<![CDATA[ ` + adDetails.Name + ` ]]>
										</AdTitle>
										<Pricing>
											<model>
												<![CDATA[ ` + pricingtype + ` ]]>
											</model>
											<currency>
												<![CDATA[ USD ]]>
											</currency>
										</Pricing>
										` + impression + `
										<VASTAdTagURI>
											<![CDATA[ ` + strings.Replace(vidad.Vast_overlay_wrapper.String, "&", "&amp;", -1) + ` ]]>
										</VASTAdTagURI>
										<Creatives>
											<Creative sequence="1">
												<NonLinearAds>
													<TrackingEvents>
														<Tracking event="creativeView">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=creativeView
															]]>
														</Tracking>
														<Tracking event="expand">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=expand
															]]>
														</Tracking>
														<Tracking event="collapse">
															<![CDATA[
																` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=collapse
															]]>
														</Tracking>
													</TrackingEvents>
													` + nonLinear + `
												</NonLinearAds>
											</Creative>
										</Creatives>
									</Wrapper>
								</Ad>
							</VAST>`
				}
			} else if vidad.Vast_type == 3 {
				if vidad.Vast_overlay_format.String == "image_overlay" {
					adDetails.Html = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.0" xsi:noNamespaceSchemaLocation="vast.xsd">
					<Ad id="` + strconv.Itoa(vidad.Banner_id) + `">
						<InLine>
							<AdSystem>
								<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
							</AdSystem>
							` + error_code + `
							<AdTitle>
								<![CDATA[ ` + adDetails.Name + ` ]]>
							</AdTitle>
							` + adVerifications + `
							` + viewableImpression + `
							` + iabcategory + `
							<Pricing>
								<model>
									<![CDATA[ ` + pricingtype + ` ]]>
								</model>
								<currency>
									<![CDATA[ USD ]]>
								</currency>
							</Pricing>
							` + impression + `
							<Creatives>
								<Creative sequence="1">
									<UniversalAdId idRegistry="unknown" idValue="unknown">"unknown"</UniversalAdId>
									<NonLinearAds>
										<TrackingEvents>
											<Tracking event="creativeView">
												<![CDATA[
													` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=creativeView
												]]>
											</Tracking>
											<Tracking event="adExpand">
												<![CDATA[
													` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=expand
												]]>
											</Tracking>
											<Tracking event="adCollapse">
												<![CDATA[
													` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=collapse
												]]>
											</Tracking>
											<Tracking event="acceptInvitation">
												<![CDATA[
													` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=acceptInvitation
												]]>
											</Tracking>
											<Tracking event="close">
												<![CDATA[
													` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=close
												]]>
											</Tracking>
											<Tracking event="overlayViewDuration">
												<![CDATA[
													` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=overlayViewDuration
												]]>
											</Tracking>
											<Tracking event="otherAdInteraction">
												<![CDATA[
													` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=otherAdInteraction
												]]>
											</Tracking>
											<Tracking event="minimize">
												<![CDATA[
													` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=exitfullscreen
												]]>
											</Tracking>
										</TrackingEvents>
										` + nonLinear + `
									</NonLinearAds>
								</Creative>
							</Creatives>
						</InLine>
					</Ad>
				</VAST>`
				} else {
					adDetails.Html = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.0" xsi:noNamespaceSchemaLocation="vast.xsd">
					<Ad id="` + strconv.Itoa(vidad.Banner_id) + `" conditionalAd="` + Is_conditionalad + `">
						<Wrapper fallbackOnNoAd="` + strconv.Itoa(vidad.Vast_wrapper_fallbacknoads) + `" allowMultipleAds="` + strconv.Itoa(vidad.Vast_wrapper_allowmultipleads) + `" followAdditionalWrappers="` + strconv.Itoa(vidad.Vast_wrapper_followadditional) + `">
							<AdSystem version="4.0">
								<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
							</AdSystem>
							` + error_code + `
							` + viewableImpression + `
							` + iabcategory + `
							<Pricing>
								<model>
									<![CDATA[ ` + pricingtype + ` ]]>
								</model>
								<currency>
									<![CDATA[ USD ]]>
								</currency>
							</Pricing>
							` + impression + `
							<VASTAdTagURI>
								<![CDATA[ ` + strings.Replace(vidad.Vast_overlay_wrapper.String, "&", "&amp;", -1) + ` ]]>
							</VASTAdTagURI>
							<Creatives>
								<Creative sequence="1">
									<NonLinearAds>
										<TrackingEvents>
											<Tracking event="creativeView">
												<![CDATA[
													` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=creativeView
												]]>
											</Tracking>
											<Tracking event="adExpand">
												<![CDATA[
													` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=expand
												]]>
											</Tracking>
											<Tracking event="adCollapse">
												<![CDATA[
													` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=collapse
												]]>
											</Tracking>
											<Tracking event="acceptInvitation">
												<![CDATA[
													` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=acceptInvitation
												]]>
											</Tracking>
											<Tracking event="close">
												<![CDATA[
													` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=close
												]]>
											</Tracking>
											<Tracking event="overlayViewDuration">
												<![CDATA[
													` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=overlayViewDuration
												]]>
											</Tracking>
											<Tracking event="otherAdInteraction">
												<![CDATA[
													` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=otherAdInteraction
												]]>
											</Tracking>
											<Tracking event="minimize">
												<![CDATA[
													` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=exitfullscreen
												]]>
											</Tracking>
										</TrackingEvents>
										` + nonLinear + `
									</NonLinearAds>
								</Creative>
							</Creatives>
						</Wrapper>
					</Ad>
				</VAST>`
				}
			} else {
				if vidad.Vast_overlay_format.String == "image_overlay" {
					adDetails.Html = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.1" xsi:noNamespaceSchemaLocation="vast.xsd">
										<Ad id="` + strconv.Itoa(vidad.Banner_id) + `">
											<InLine>
												<AdSystem>
													<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
												</AdSystem>
												` + error_code + `
												<AdTitle>
													<![CDATA[ ` + adDetails.Name + ` ]]>
												</AdTitle>
												<AdServingId>` + adservingid + `</AdServingId>
												` + advertiser + `
												<Description>` + adDetails.Name + `</Description>
												` + expiretime + `
												` + adVerifications + `
												` + viewableImpression + `
												` + iabcategory + `
												<Pricing>
													<model>
														<![CDATA[ ` + pricingtype + ` ]]>
													</model>
													<currency>
														<![CDATA[ USD ]]>
													</currency>
												</Pricing>
												` + impression + `
												<Creatives>
													<Creative sequence="1">
														<UniversalAdId idRegistry="unknown" idValue="unknown">"unknown"</UniversalAdId>
														<NonLinearAds>
															<TrackingEvents>
																<Tracking event="creativeView">
																	<![CDATA[
																		` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=creativeView
																	]]>
																</Tracking>
																<Tracking event="adExpand">
																	<![CDATA[
																		` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=expand
																	]]>
																</Tracking>
																<Tracking event="adCollapse">
																	<![CDATA[
																		` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=collapse
																	]]>
																</Tracking>
																<Tracking event="acceptInvitation">
																	<![CDATA[
																		` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=acceptInvitation
																	]]>
																</Tracking>
																<Tracking event="close">
																	<![CDATA[
																		` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=close
																	]]>
																</Tracking>
																<Tracking event="overlayViewDuration">
																	<![CDATA[
																		` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=overlayViewDuration
																	]]>
																</Tracking>
																<Tracking event="otherAdInteraction">
																	<![CDATA[
																		` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=otherAdInteraction
																	]]>
																</Tracking>
																<Tracking event="minimize">
																	<![CDATA[
																		` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=exitfullscreen
																	]]>
																</Tracking>
															</TrackingEvents>
															` + nonLinear + `
														</NonLinearAds>
													</Creative>
												</Creatives>
											</InLine>
										</Ad>	
									</VAST>`
				} else {
					adDetails.Html = `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.1" xsi:noNamespaceSchemaLocation="vast.xsd">
										<Ad id="` + strconv.Itoa(vidad.Banner_id) + `" conditionalAd="` + Is_conditionalad + `">
											<Wrapper fallbackOnNoAd="` + strconv.Itoa(vidad.Vast_wrapper_fallbacknoads) + `" allowMultipleAds="` + strconv.Itoa(vidad.Vast_wrapper_allowmultipleads) + `" followAdditionalWrappers="` + strconv.Itoa(vidad.Vast_wrapper_followadditional) + `">
												<AdSystem version="4.1">
													<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
												</AdSystem>
												<AdServingId>` + adservingid + `</AdServingId>
												` + advertiser + `
												<Description>` + adDetails.Name + `</Description>
												` + expiretime + `
												` + error_code + `
												` + viewableImpression + `
												` + iabcategory + `
												<Pricing>
													<model>
														<![CDATA[ ` + pricingtype + ` ]]>
													</model>
													<currency>
														<![CDATA[ USD ]]>
													</currency>
												</Pricing>
												` + impression + `
												<VASTAdTagURI>
													<![CDATA[ ` + strings.Replace(vidad.Vast_overlay_wrapper.String, "&", "&amp;", -1) + ` ]]>
												</VASTAdTagURI>
												<Creatives>
													<Creative sequence="1">
														<NonLinearAds>
															<TrackingEvents>
																<Tracking event="creativeView">
																	<![CDATA[
																		` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=creativeView
																	]]>
																</Tracking>
																<Tracking event="adExpand">
																	<![CDATA[
																		` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=expand
																	]]>
																</Tracking>
																<Tracking event="adCollapse">
																	<![CDATA[
																		` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=collapse
																	]]>
																</Tracking>
																<Tracking event="acceptInvitation">
																	<![CDATA[
																		` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=acceptInvitation
																	]]>
																</Tracking>
																<Tracking event="close">
																	<![CDATA[
																		` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=close
																	]]>
																</Tracking>
																<Tracking event="overlayViewDuration">
																	<![CDATA[
																		` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=overlayViewDuration
																	]]>
																</Tracking>
																<Tracking event="otherAdInteraction">
																	<![CDATA[
																		` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=otherAdInteraction
																	]]>
																</Tracking>
																<Tracking event="minimize">
																	<![CDATA[
																		` + fc_path + `?script=djaxvideoAds:djaxvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=exitfullscreen
																	]]>
																</Tracking>
															</TrackingEvents>
															` + nonLinear + `
														</NonLinearAds>
													</Creative>
												</Creatives>
											</Wrapper>
										</Ad>
									</VAST>`
				}
			}
		}

		
		
}

 
 
	
func AdRenderOutstreamVideoAd_external(vasturl string,ad_type int) string {
	
	
	
	video_url := config.GetConfig("protocol","webpath") + config.GetConfig("admin","webpath")+`/plugins/Outstream/delivery/js/videoplayback.mp4`
	

	rt :=  rand.Intn(999999)
	id :=  "vjs_"+strconv.Itoa(rt)
	rand1 := helper.RandToken(5)
	var s, s1 string
	s = config.GetConfig("protocol","webpath") + config.GetConfig("admin","webpath")+ `/plugins/Outstream/delivery/fluid/fluidplayer.min.js`
	s1 = config.GetConfig("protocol","webpath") + config.GetConfig("admin","webpath")+ `/plugins/Outstream/delivery/fluid/jquery.min.js`
		
		encs :=  md5.New()
	encs.Write([]byte(s))
	encs1 := md5.New()
	encs1.Write([]byte(s1))
	
	
	var html string
	 
		if ad_type == 1  { //In Article
	
			html = `<link rel="stylesheet" href="` + config.GetConfig("protocol","webpath") + config.GetConfig("admin","webpath")+`/plugins/Outstream/delivery/fluid/fluidplayer.min.css" type="text/css">

			<script>
		
				if (typeof fluidplayer_scripts == 'undefined') 
				{
						var fluidplayer_scripts = [];
				}
	
				function loadScript(url,md5, callback)
				{
					if(fluidplayer_scripts.includes(md5) == false)
					{
					
					
				    var script = document.createElement("script");
				    script.type = "text/javascript"; 

				    if (script.readyState){ 
				        script.onreadystatechange = function(){
				            if (script.readyState == "loaded" ||
				                    script.readyState == "complete"){
				                script.onreadystatechange = null;
				                callback();

				            }
				        };
				    } else {  
				        script.onload = function(){
							callback();	
				        };
				    }

				    script.src = url;
				    document.getElementsByTagName("head")[0].appendChild(script);
				    
				    fluidplayer_scripts.push(md5);
					
					}
					else
					{
					setTimeout(function() {
						callback();
						}, 1000); 
					}
				}
				
				loadScript("`+s+`","`+hex.EncodeToString(encs.Sum(nil))+`", function() {  load_ply_`+id+`()   }  );
				loadScript("`+s1+`","`+hex.EncodeToString(encs1.Sum(nil))+`", function() {  load_ply_`+id+`()   }  );
			</script>

			<style>            
	            .video-js .vjs-time-control, .video-js .vjs-fullscreen-control, .video-js .vjs-progress-control
	            {
	                display: none;
	            }
	            
	            .video-js .vjs-time-control, .video-js .vjs-fullscreen-control, .video-js .vjs-progress-control
	            {
	                display: none;
	            }

	            @media only screen and (min-width: 10px) and (max-width: 299px)
	            {
	                #`+id+`
	                {
	                    height: 150px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 300px) and (max-width: 399px)
	            {
	                #`+id+`
	                {
	                    height: 200px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 400px) and (max-width: 650px)
	            {
	                #`+id+`
	                {
	                    height: 300px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 651px) and (max-width: 800px)
	            {
	                #`+id+`
	                {
	                    height: 400px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 801px) and (max-width: 1000px)
	            {
	                #`+id+`
	                {
	                    height: 500px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 1001px) and (max-width: 2000px)
	            {
	                #`+id+`
	                {
	                    height: 600px; 
	                    width: auto;  
	                }
	            }
	            @media only screen and (min-width: 2001px)
	                #`+id+`
	                {
	                    height: 700px; 
	                    width: auto; 
	                }
	            }
	            
            </style>
             
            <div id="test-ad`+rand1+`">
	   			<style>
					.fluid_context_menu, .fluid_controls_left , .fluid_control_duration , .ad_countdown  ,.fluid_controls_progress_container
					{
					    display: none !important;

					}
		        	#admedia`+rand1+` img
		        	{
		            	position: relative !important;
		        	}
		        	
		        	
		        </style>

		        <div id="admedia`+rand1+`">
					<div class="rm_videowrapper`+id+`" id="rm_videowrapper`+id+`">
				        <center><span style="font-size:1.5vh;">ADVERTISEMENT</span></center>
						<center><video id="`+id+`"  autoplay="false" muted="muted">
		                    <source src="`+video_url+`" type="video/mp4">
		                </video></center>
				        <span></span>
				        
			        </div>
		        </div>
	        </div>	
      		<script> 
        
	    		function tracking_event_`+id+`(track_type) {
	              
	            }


	            var fluidPlayer`+id+`_run = 1;  
		           
	            var icc`+id+` = 0;
			    function load_ply_`+id+`() {   
					icc`+id+`++;

					if(icc`+id+` != 2 ) {

					return false;
				}

	            var fluidPlayer`+id+` = fluidPlayer("`+id+`", {
	                layoutControls: {
	                    primaryColor: false,
	                    playButtonShowing: true,
	                    playPauseAnimation: true,
	                    fillToContainer: false,
	                    autoPlay: false,
	                    preload: false,
	                    mute: true,
	                    doubleclickFullscreen: false,
	                    subtitlesEnabled: false,
	                    keyboardControl: true,
	                    layout: "default",
	                    allowDownload: false,
	                    playbackRateEnabled: false,
	                    allowTheatre: false,
	                    title: false,
	                    controlBar: {
	                        autoHide: false
	                    }
	                },
	                "vastOptions": {
	                    "allowVPAID": "true", 
	                    "adList": [
	                        {
	                            "roll": "preRoll",
	                            "vastTag": "`+ vasturl +`",
	                            "adClickable": "true"
	                        }
	                    ],
	                    vastAdvanced: {
	                        vastLoadedCallback:       (function() {}),
	                        noVastVideoCallback:      (function() {}),
	                        vastVideoSkippedCallback: (function() { 
	                            $("#rm_videowrapper`+id+`").slideUp(800);
	                            show_vid = 4; 
	                            tracking_event_`+id+`("skip"); 
	                            fluidPlayer`+id+`_run = 0;
	                        }),
	                        vastVideoEndedCallback:   (function() { 
	                            $("#rm_videowrapper`+id+`").slideUp(800);
	                            show_vid = 4; 
	                            tracking_event_`+id+`("complete"); 
	                            fluidPlayer`+id+`_run = 0;
	                        })
	                    }
	                }
	            });

        	    fluidPlayer`+id+`.on("pause", function(){ tracking_event_`+id+`("pause"); });
	            fluidPlayer`+id+`.on("theatreModeOn", function(){ tracking_event_`+id+`("fullscreen"); });
	            fluidPlayer`+id+`.on("theatreModeOff", function(){ tracking_event_`+id+`("exitfullscreen"); });
           
                setTimeout(function(){ 
                    fluidPlayer`+id+`.pause(); 
                },2000);
                
                var height`+id+` = $("#rm_videowrapper`+id+`").height();
                var width`+id+` = $("#rm_videowrapper`+id+`").width();

                var div_position`+id+` = $("#rm_videowrapper`+id+`").offset();
            	var visible_height`+id+` = height`+id+`/2;
                
                $("#rm_videowrapper`+id+`").hide();
                var show_vid`+id+` = 1;

                var visible_height`+id+` = height`+id+`/2;
                var user_pause`+id+` = 0;

                $("#`+id+`_fluid_control_playpause").click(function() {
                    (user_pause`+id+` == 0) ? user_pause`+id+` = 1 : user_pause`+id+` = 0;
                });
                var first_occuresce`+id+` = 0;

                $(window).scroll(function()
                {
                    var visible_height_up`+id+` = div_position`+id+`.top+(visible_height`+id+`);
                    var screen_height`+id+` = $(window).height();
                    var visible_height_down`+id+` = (div_position`+id+`.top+visible_height`+id+`)-screen_height`+id+`;
                    scroll_position`+id+` = $(window).scrollTop();

                    if(scroll_position`+id+` >= visible_height_up`+id+` || scroll_position`+id+` <= visible_height_down`+id+`)
                    {
                        fluidPlayer`+id+`.pause();
                    }
                    else
                    {
                        if(user_pause`+id+` == 0)
                        {
                            fluidPlayer`+id+`.play(); 	
                        }
                        
                        if(first_occuresce`+id+` == 0)
                        {
                            $("#rm_videowrapper`+id+`").slideDown(800);
                            first_occuresce`+id+` = 1;
                        }
                    }
                });

            	$(window).scroll();
         	}
                
    		</script> 
		</div>`

	} else if ad_type ==  3 {  // intersitial

    		externalAdStyle:= `<style>            
	            .video-js .vjs-time-control, .video-js .vjs-fullscreen-control, .video-js .vjs-progress-control
	            {
	                display: none;
	            }
	            
	            .video-js .vjs-time-control, .video-js .vjs-fullscreen-control, .video-js .vjs-progress-control
	            {
	                display: none;
	            }

	            @media only screen and (min-width: 10px) and (max-width: 299px)
	            {
	                #`+id+`
	                {
	                    height: 150px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 300px) and (max-width: 399px)
	            {
	                #`+id+`
	                {
	                    height: 200px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 400px) and (max-width: 650px)
	            {
	                #`+id+`
	                {
	                    height: 300px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 651px) and (max-width: 800px)
	            {
	                #`+id+`
	                {
	                    height: 400px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 801px) and (max-width: 1000px)
	            {
	                #`+id+`
	                {
	                    height: 500px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 1001px) and (max-width: 2000px)
	            {
	                #`+id+`
	                {
	                    height: 600px; 
	                    width: auto;  
	                }
	            }
	            @media only screen and (min-width: 2001px)
	                #`+id+`
	                {
	                    height: 700px; 
	                    width: auto; 
	                }
	            }

	       		</style>`
        

	
			html = externalAdStyle+`<link rel="stylesheet" href="` + config.GetConfig("protocol","webpath") + config.GetConfig("admin","webpath")+`/plugins/Outstream/delivery/fluid/fluidplayer.min.css" type="text/css">
				<script>
			


					if (typeof fluidplayer_scripts == 'undefined') 
					{
							var fluidplayer_scripts = [];
					}
		
		
					function loadScript(url,md5, callback)
					{
						if(fluidplayer_scripts.includes(md5) == false)
						{
						
						
					    var script = document.createElement("script");
					    script.type = "text/javascript";

					    if (script.readyState){ 
					        script.onreadystatechange = function(){
					            if (script.readyState == "loaded" ||
					                    script.readyState == "complete"){
					                script.onreadystatechange = null;
					                callback();

					            }
					        };
					    } else {  
					        script.onload = function(){
								callback();	
					        };
					    }

					    script.src = url;
					    document.getElementsByTagName("head")[0].appendChild(script);
					    
					    fluidplayer_scripts.push(md5);
						
						}
						else
						{
						setTimeout(function() {
							callback();
							}, 1000); 
						}
					    			
					}
					loadScript("`+s+`","`+hex.EncodeToString(encs.Sum(nil))+`", function() {  load_ply_`+id+`()   }  );
					loadScript("`+s1+`","`+hex.EncodeToString(encs1.Sum(nil))+`", function() {  load_ply_`+id+`()   }  );
				</script>

				<style>            
		            .video-js .vjs-time-control, .video-js .vjs-fullscreen-control, .video-js .vjs-progress-control
					{
						display: none;
					}  

					@media only screen and (min-width: 100px) and (max-width: 790px)
					{
						#rm_videowrapper`+id+`{
							margin-top: 50%;
						}

					}	

					@media only screen and (min-width: 10px) and (max-width: 299px)
					{
						#`+id+`
						{
							position: relative;
							margin-top: 50%;
				   			height: 150px; 
				   			width: auto; 
						};
					}

		            @media only screen and (min-width: 300px) and (max-width: 399px)
		            {
		                #`+id+`
		                {
		                	position: relative;
							margin-top: 50%;
		                    height: 200px; 
		                    width: auto; 
		                }
		            }
		            
		            @media only screen and (min-width: 400px) and (max-width: 650px)
		            {
		                #`+id+`
		                {
		                	position: relative;
							margin-top: 50%;
		                    height: 300px; 
		                    width: auto; 
		                }
		            }
		            
		            @media only screen and (min-width: 651px) and (max-width: 900px)
		            {
		                #`+id+`
		                {
		                    height: 400px; 
		                    width: auto; 
		                }
		            }
		            @media only screen and (min-width: 901px)
		            {
		                #`+id+`
		                {
		                    height: 400px; 
				   			width: auto; 
				   			margin-top: 20px;
		                }
		            }
		            @media only screen and (min-width: 100px) and (max-width: 980px)
		            {
		               	.volume_controls{
							position: relative;
							margin-top: -45px;
							float: left;
							left: 26%;
							z-index: 1;
							
						}
		            }
		            @media only screen and(min-width: 981px) and (max-width: 1080px)
		            {
		                .volume_controls{
							position: relative;
							margin-top: -45px;
							float: left;
							left: 28%;
							z-index: 1;
							
						}
		            }

		            @media only screen and (min-width: 1081px) and (max-width: 1420px)
					{
						.volume_controls{
							position: relative;
							margin-top: -45px;
							float: left;
							left: 32%;
							z-index: 1;
						}
					}

					@media only screen and (min-width: 1421px) and (max-width: 1560px)
					{
						.volume_controls{
							position: relative;
							margin-top: -45px;
							float: left;
							left: 35%;
							z-index: 1;
						}
					}

					@media only screen and (min-width: 1561px) and (max-width: 1825px)
					{
						.volume_controls{
							position: relative;
							margin-top: -45px;
							float: left;
							left: 37%;
							z-index: 1;
						}
					}

					@media only screen and (min-width: 1826px) 
					{
						.volume_controls{
							position: relative;
							margin-top: -45px;
							float: left;
							left: 42%;
							z-index: 1;
						}
					}
		
					.fluid_context_menu, .fluid_controls_left , .fluid_control_duration , .ad_countdown  ,.fluid_controls_progress_container
					{
					    display: none !important;

					}
    	
    				#rm_videowrapper`+id+`
					{
						margin-left: auto;
						margin-right: auto;
						width:  90%;
						height: 90%;
					}
					#intersitial_outstream`+id+`{
						position: fixed;
						z-index: 9999;
						background: rgba(0, 0, 0, 0.75);
						top: 0;
						    left: 0;

						width: 100%;
						height: 100%;
					}
					.text-white{
						color: #fff;
					}
					#interstitial-footer`+id+`{
						text-align : right;
						margin-left: 550px;
						padding-top: 10px;
					}
					
					
		        </style>

		        <div id="intersitial_outstream`+id+`">
					<div id="rm_videowrapper`+id+`">
						<center>
							<video id="`+id+`" autoplay="false" muted="muted" style="position: relative;"><source src="`+video_url+`" type="video/mp4"></video>
							<div class="interstitial-footer" id="interstitial-footer" >
						    	<button type="button" class="btn btn-primary" id="close_interstitial_ad`+id+`" data-dismiss="modal">Close</button>
						    </div>
						</center>
					</div>
				</div>

				<script> 
	    	var fluidPlayer`+id+`_run = 1;
	    	
	    	   function tracking_event_`+id+`(track_type) {
	        	
	        }
	        
	        
    	  	var icc`+id+` = 0;
     		function load_ply_`+id+`() {   
				icc`+id+`++;
				if(icc`+id+` != 2 ) {
					return false;
				}	  	
		  	

	    	var fluidPlayer`+id+` = fluidPlayer("`+id+`", {
	    		layoutControls: {
		            primaryColor:           false,
		            playButtonShowing:      true,
		            playPauseAnimation:     true,
		            fillToContainer:        false,
		            autoPlay:               false,
		            preload:                false,
		            mute:                   true,
		            doubleclickFullscreen:  true,
		            subtitlesEnabled:       false,
		            keyboardControl:        true,
		            layout:                 "default",
		            allowDownload:          false,
		            playbackRateEnabled:    false,
		            allowTheatre:           true,
		            title:                  false,
		            controlBar: {
		                autoHide:           false
		            }
		        },
	            "vastOptions": {
	            	maxAllowedVastTagRedirects: 1,
	                "allowVPAID": "true",
	                "adList": [
	                    {
	                        "roll": "preRoll",
	                        "vastTag": "`+vasturl+`",
	                        adClickable: true
	                    }
	                ],
	                vastAdvanced: {
	                	vastLoadedCallback:       (function() {}),
	                	noVastVideoCallback:      (function() {}),
		                vastVideoSkippedCallback: (function() { 
		                	$("#intersitial_outstream").slideUp(800);
		                	show_vid = 4;
		                	tracking_event_`+id+`("skip"); 
		                	fluidPlayer`+id+`_run = 0; 
		                }),
		                vastVideoEndedCallback:   (function() { 
		                	$("#intersitial_outstream").slideUp(800);
		                	show_vid = 4; 
		                	tracking_event_`+id+`("complete"); 
		                	fluidPlayer`+id+`_run = 0;
		                })
		            }
	            }
	        });

	     

	        fluidPlayer`+id+`.on("play", function(){ tracking_event_`+id+`("resume"); });
	        fluidPlayer`+id+`.on("pause", function(){ tracking_event_`+id+`("pause"); });
	        fluidPlayer`+id+`.on("theatreModeOn", function(){ tracking_event_`+id+`("fullscreen"); });
	        fluidPlayer`+id+`.on("theatreModeOff", function(){ tracking_event_`+id+`("exitfullscreen"); });

			
			
		
			fluidPlayer`+id+`.play();


			fluidPlayer`+id+`.on("ended", function()
			{	  
    			close_vid`+id+`();				
			});
	     

	        $("#close_interstitial_ad`+id+`").click(function(){
	        	close_vid`+id+`();
	        });

			}

	        function close_vid`+id+`()
	        {
	        	$("#intersitial_outstream`+id+`").slideUp(1000);
	        }     
	    </script>`

	}  else if ad_type == 4 {  //Infeed

		html = `<link rel="stylesheet" href="` + config.GetConfig("protocol","webpath") + config.GetConfig("admin","webpath")+`/plugins/Outstream/delivery/fluid/fluidplayer.min.css" type="text/css"/>
		<script>
		
			if (typeof fluidplayer_scripts == 'undefined')  {
					var fluidplayer_scripts = [];
			}

			function loadScript(url,md5, callback)
			{
				if(fluidplayer_scripts.includes(md5) == false)
				{
			    var script = document.createElement("script");
			    script.type = "text/javascript";

			    if (script.readyState){ 
			        script.onreadystatechange = function(){
			            if (script.readyState == "loaded" ||
			                    script.readyState == "complete"){
			                script.onreadystatechange = null;
			                callback();

			            }
			        };
			    } else {  
			        script.onload = function(){
						callback();	
			        };
			    }

			    script.src = url;
			    document.getElementsByTagName("head")[0].appendChild(script);
			    
			    fluidplayer_scripts.push(md5);
				
				}
				else
				{
				setTimeout(function() {
					callback();
					}, 1000); 
				}
			}
			loadScript("`+s+`","`+hex.EncodeToString(encs.Sum(nil))+`", function() {  load_ply_`+id+`()   }  );
			loadScript("`+s1+`","`+hex.EncodeToString(encs1.Sum(nil))+`", function() {  load_ply_`+id+`()   }  );
		</script>
		
		<style>
			.video-js .vjs-time-control, .video-js .vjs-fullscreen-control, .video-js .vjs-progress-control
			{
				display: none;
			}
			@media only screen and (min-width: 10px) and (max-width: 299px)
			{
				#`+id+`
				{
		   			height: 150px; 
		   			width: auto; 
				}
			}
			@media only screen and (min-width: 300px) and (max-width: 399px)
			{
				#`+id+`
				{
		   			height: 200px; 
		   			width: auto; 
				}
			}
			@media only screen and (min-width: 400px) and (max-width: 650px)
			{
				#`+id+`
				{
		   			height: 300px; 
		   			width: auto; 
				}
			}
			@media only screen and (min-width: 651px) and (max-width: 800px)
			{
				#`+id+`
				{
		   			height: 400px; 
		   			width: auto; 
				}
			}
			@media only screen and (min-width: 801px) and (max-width: 1000px)
			{
				#`+id+`
				{
		   			height: 500px; 
		   			width: auto; 
				}
			}
			@media only screen and (min-width: 1001px) and (max-width: 2000px)
			{
				#`+id+`
				{
		   			height: 600px; 
		   			width: auto; 
				}
			}
			@media only screen and (min-width: 2001px)
				#`+id+`
				{
		   			height: 700px; 
		   			width: auto; 
				}
			}
		</style>
		<div id="test-ad`+rand1+`">
		   	<style>
          		.fluid_context_menu, .fluid_controls_left , .fluid_control_duration , .ad_countdown  ,.fluid_controls_progress_container
				{
				    display: none !important;

				} 
            	.admedia`+rand1+` img
            	{
                	position: relative !important;
            	}           	
            	
            </style>
	        <div class="admedia`+rand1+`" >
				<center>
					<div id="outstream`+id+`" style="background-color: white;" >
						<video id="`+id+`" autoplay="false" muted="muted" style="position: relative;">	 
							<source src="`+video_url+`" type="video/mp4">	
						</video>
					</div>
				</center>
			</div>
		</div>

    	<script> 
		   var fluidPlayer`+id+`_run = 1;
         
        
        	function tracking_event_`+id+`(track_type) {
    			
        	}

     		var fluidPlayer`+id+`_run = 1;   
            
    		var icc`+id+` = 0;
 			function load_ply_`+id+`() {   
				icc`+id+`++;
				if(icc`+id+` != 2 ) {
					return false;
				}  	
	    		var fluidPlayer`+id+` = fluidPlayer("`+id+`", {
    				layoutControls: {
			            primaryColor:           false,
			            playButtonShowing:      true,
			            playPauseAnimation:     true,
			            fillToContainer:        false,
			            autoPlay:               false,
			            preload:                false,
			            mute:                   true,
			            doubleclickFullscreen:  true,
			            subtitlesEnabled:       false,
			            keyboardControl:        true,
			            layout:                 "default",
			            allowDownload:          false,
			            playbackRateEnabled:    false,
			            allowTheatre:           true,
			            title:                  false,
			            controlBar: {
			                autoHide:           false
			            }
			        },
		            "vastOptions": {
		            	maxAllowedVastTagRedirects: 1,
		                "allowVPAID": "true", 
		                "adList": [
		                    {
		                        "roll": "preRoll",
		                        "vastTag": "`+vasturl+`",
		                        adClickable: true
		                    }
		                ],
                		vastAdvanced: {
                			vastLoadedCallback: (function() {}),
                			noVastVideoCallback: (function() {}),
	                		vastVideoSkippedCallback: (function() { 
                				$("#outstream`+id+`").slideUp(800);
	                			show_vid = 4;
	                			tracking_event_`+id+`("skip"); 
	                			fluidPlayer`+id+`_run = 0; 
                			}),
	                		vastVideoEndedCallback: (function() { 
	                			$("#outstream`+id+`").slideUp(800);
	                			show_vid = 4;
	                			tracking_event_`+id+`("complete"); 
	                			fluidPlayer`+id+`_run = 0; 
                			})
	            		}
            		}
        		});

		        fluidPlayer`+id+`.on("play", function(){ tracking_event_`+id+`("resume"); });
		        fluidPlayer`+id+`.on("pause", function(){ tracking_event_`+id+`("pause"); });
		        fluidPlayer`+id+`.on("theatreModeOn", function(){ tracking_event_`+id+`("fullscreen"); });
		        fluidPlayer`+id+`.on("theatreModeOff", function(){ tracking_event_`+id+`("exitfullscreen"); });

				setTimeout(function(){ 
					fluidPlayer`+id+`.pause(); 
				},2000);

				var height`+id+` = $("#outstream`+id+`").height();
				var width`+id+`  = $("#outstream`+id+`").width();

				var div_position`+id+` = $("#outstream`+id+`").offset();
				var visible_height`+id+` = height`+id+`/2;

				$("#outstream`+id+`").css("opacity","0");
				$("#outstream`+id+`").hide(-9000);
				
				var show_vid`+id+` = 1;

				var user_pause`+id+` = 0;

				$("#`+id+`_fluid_control_playpause").click(function()  {
					(user_pause`+id+` == 0) ? user_paus`+id+` = 1 : user_pause`+id+` = 0;
				});
			
				$(window).scroll(function()
				{ 					
					var visible_height_up`+id+` = div_position`+id+`.top+(visible_height`+id+`);
					var screen_height`+id+` = $(window).height();
					var visible_height_down`+id+` = (div_position`+id+`.top+visible_height`+id+`)-screen_height`+id+`;

					scroll_position`+id+` = $(window).scrollTop();

					if(scroll_position`+id+` >= visible_height_up`+id+` || scroll_position`+id+` <= visible_height_down`+id+`)
					{
						if( show_vid`+id+` != 1)
						{
							fluidPlayer`+id+`.pause();
						}
					}
					else
					{

						if( show_vid`+id+` == 1 && user_pause`+id+` == 0)
						{
							$("#outstream`+id+`").css("opacity","1");
							$("#outstream`+id+`").slideDown(800);
							show_vid`+id+` = 2 ;
							fluidPlayer`+id+`.play();
						}
						else if(show_vid`+id+` == 2 && user_pause`+id+` == 0)
						{
							fluidPlayer`+id+`.play();
						}
					}
				});

				$(window).scroll();

				$("#outstream`+id+`").mouseenter(function()
				{
					tracking_event_`+id+`("unmute");
				    fluidPlayer`+id+`.setVolume(0.5); 
				});

				$("#outstream`+id+`").mouseout(function()
				{
					tracking_event_`+id+`("mute");
				    fluidPlayer`+id+`.setVolume(0); 
				});
			}
		</script>` 
	}
	
	
	return html;
}


	

func AdRenderOutstreamVideoAd(adDetails *structure.AdDetails, zn structure.ZoneInfo,r *http.Request) {
	
	table_prefix := config.GetConfig("prefix", "table")	
	var client_table = table_prefix + "clients"
	var campaign_table = table_prefix + "campaigns"
	var adservingid string 
	adservingid = helper.RandToken(5) + strconv.Itoa(adDetails.Ad_id)
	hasher := md5.New()
	hasher.Write([]byte(adservingid))
	adservingid = hex.EncodeToString(hasher.Sum(nil))

	/*Advertiser*/
	var clientid int
	var clientname,id string
	var clientexp time.Time
	db.DbQueryRow("select cl.clientid as clientid,cl.clientname as name,c.expire_time as expire_time from "+client_table+" as cl,"+campaign_table+" as c where c.clientid=cl.clientid and c.campaignid=?", adDetails.Placement_id).Scan(&clientid, &clientname, &clientexp)



	rt :=  rand.Intn(999999)
	id =  "vjs_"+strconv.Itoa(rt)
	rand1 := helper.RandToken(5)
	
	var bnrParams  map[interface{}]interface{}
	phpserialize.Unmarshal([]byte(adDetails.Parameters), &bnrParams)

	var video_url,destination_url, iconUrl, cta_text,title, sponser_text,textDesc,vid_delpath, bg_image string
	
	if bnrParams["destination_url"] != ""{
		destination_url = bnrParams["destination_url"].(string)
	}else{
		destination_url = ""
	}	

	if bnrParams["icon_url"] != ""{
		iconUrl = bnrParams["icon_url"].(string)
	}else{
		iconUrl = ""
	}

	if bnrParams["cta_text"] != ""{
		cta_text = bnrParams["cta_text"].(string)
	}else{
		cta_text = ""
	}

	if bnrParams["title"] != ""{
		title = bnrParams["title"].(string)
	}else{
		title = ""
	}

	if bnrParams["sponser_text"] != ""{
		sponser_text = bnrParams["sponser_text"].(string)
	}else{
		sponser_text = ""
	}

	if bnrParams["text_description"] != ""{
		textDesc = bnrParams["text_description"].(string)
	}else{
		textDesc = ""
	}

	/*if bnrParams["height"] != ""{
		height = bnrParams["height"].(string)
	}else{
		height = ""
	}

	if bnrParams["width"] != ""{
		width = bnrParams["width"].(string)
	}else{
		width = ""
	}*/

	if bnrParams["bg_image"] != ""{
		bg_image = bnrParams["bg_image"].(string)
	}else{
		bg_image = ""
	}

	if bnrParams["vid_upload_type"] == "External"{
		video_url = bnrParams["video_url"].(string)
	}else if bnrParams["vid_upload_type"] == "Internal"{
		video_url = config.GetConfig("protocol","webpath") + config.GetConfig("images","webpath") + bnrParams["rm_video"].(string)
	}
	
	video_url = config.GetConfig("protocol","webpath") + config.GetConfig("admin","webpath")+`/plugins/Outstream/delivery/js/videoplayback.mp4`
	

		zoneid := strconv.Itoa(zn.Zoneid)
	adid := strconv.Itoa(adDetails.Ad_id)
	campaign_id := strconv.Itoa(adDetails.Placement_id)
	 
	vid_delpath = vastXml(adDetails, zn)
	
		
	if bnrParams["vid_type"] == "Internal"  {

	vid_delpath = config.GetConfig("protocol","webpath") + config.GetConfig("admin","webpath")+`/plugins/Outstream/xml_response/vast3xml.php?zoneid=`+zoneid+`&campaignid=`+campaign_id+`&bannerid=`+adid
	} else {
		
		vid_delpath = config.GetConfig("protocol","webpath") + config.GetConfig("admin","webpath")+`/plugins/Outstream/xml_response/vast3_wrapperxml.php?zoneid=`+zoneid+`&campaignid=`+campaign_id+`&bannerid=`+adid
	} 
	
	  
	var externalAdStyle,s, s1 string
	s = config.GetConfig("protocol","webpath") + config.GetConfig("admin","webpath")+ `/plugins/Outstream/delivery/fluid/fluidplayer.min.js`
	s1 = config.GetConfig("protocol","webpath") + config.GetConfig("admin","webpath")+ `/plugins/Outstream/delivery/fluid/jquery.min.js`
		
	encs :=  md5.New()
	encs.Write([]byte(s))
	encs1 := md5.New()
	encs1.Write([]byte(s1))
		
	if bnrParams["ad_type"] == "1" || bnrParams["vid_type"] == "External" { //In Article
	
			adDetails.Html = `<link rel="stylesheet" href="` + config.GetConfig("protocol","webpath") + config.GetConfig("admin","webpath")+`/plugins/Outstream/delivery/fluid/fluidplayer.min.css" type="text/css">

			<script>
		
				if (typeof fluidplayer_scripts == 'undefined') 
				{
						var fluidplayer_scripts = [];
				}
	
				function loadScript(url,md5, callback)
				{
					if(fluidplayer_scripts.includes(md5) == false)
					{
					
					
				    var script = document.createElement("script");
				    script.type = "text/javascript"; 

				    if (script.readyState){ 
				        script.onreadystatechange = function(){
				            if (script.readyState == "loaded" ||
				                    script.readyState == "complete"){
				                script.onreadystatechange = null;
				                callback();

				            }
				        };
				    } else {  
				        script.onload = function(){
							callback();	
				        };
				    }

				    script.src = url;
				    document.getElementsByTagName("head")[0].appendChild(script);
				    
				    fluidplayer_scripts.push(md5);
					
					}
					else
					{
					setTimeout(function() {
						callback();
						}, 1000); 
					}
				}
				
				loadScript("`+s+`","`+hex.EncodeToString(encs.Sum(nil))+`", function() {  load_ply_`+id+`()   }  );
				loadScript("`+s1+`","`+hex.EncodeToString(encs1.Sum(nil))+`", function() {  load_ply_`+id+`()   }  );
			</script>

			<style>            
	            .video-js .vjs-time-control, .video-js .vjs-fullscreen-control, .video-js .vjs-progress-control
	            {
	                display: none;
	            }
	            
	            .video-js .vjs-time-control, .video-js .vjs-fullscreen-control, .video-js .vjs-progress-control
	            {
	                display: none;
	            }

	            @media only screen and (min-width: 10px) and (max-width: 299px)
	            {
	                #`+id+`
	                {
	                    height: 150px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 300px) and (max-width: 399px)
	            {
	                #`+id+`
	                {
	                    height: 200px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 400px) and (max-width: 650px)
	            {
	                #`+id+`
	                {
	                    height: 300px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 651px) and (max-width: 800px)
	            {
	                #`+id+`
	                {
	                    height: 400px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 801px) and (max-width: 1000px)
	            {
	                #`+id+`
	                {
	                    height: 500px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 1001px) and (max-width: 2000px)
	            {
	                #`+id+`
	                {
	                    height: 600px; 
	                    width: auto;  
	                }
	            }
	            @media only screen and (min-width: 2001px)
	                #`+id+`
	                {
	                    height: 700px; 
	                    width: auto; 
	                }
	            }
	            
            </style>
             
            <div id="test-ad`+rand1+`">
	   			<style>
					.fluid_context_menu, .fluid_controls_left , .fluid_control_duration , .ad_countdown  ,.fluid_controls_progress_container
					{
					    display: none !important;

					}
		        	#admedia`+rand1+` img
		        	{
		            	position: relative !important;
		        	}
		        	
		        	
		        </style>

		        <div id="admedia`+rand1+`">
					<div class="rm_videowrapper`+id+`" id="rm_videowrapper`+id+`">
				        <center><span style="font-size:1.5vh;">ADVERTISEMENT</span></center>
						<center><video id="`+id+`"  autoplay="false" muted="muted">
		                    <source src="`+video_url+`" type="video/mp4">
		                </video></center>
				        <span></span>
				        
			        </div>
		        </div>
	        </div>	
      		<script> 
        
	    		function tracking_event_`+id+`(track_type) {
	                if(fluidPlayer`+id+`_run == 1) {
	        		var track_url = "`+config.GetConfig("protocol","webpath") + config.GetConfig("delivery","webpath")+`/fc.php?script=rmvideoAds:rmvastEvent&bannerid=`+strconv.Itoa(adDetails.Ad_id)+`&zoneid=`+strconv.Itoa(zn.Zoneid)+`&event="+track_type;

	                    $.ajax({
	                        type: "get",
	                        url: track_url,
	                        cache: false,
	                        success: function (json) {
	                            try {
	                                console.log("Track event success");
	                            } catch (e) {
	                                console.log("Exception while request..");
	                            }
	                        },
	                        error: function () {
	                            console.log("Error while request..");
	                        }
	                    });
	                }
	            }


	            var fluidPlayer`+id+`_run = 1;  
		           
	            var icc`+id+` = 0;
			    function load_ply_`+id+`() {   
					icc`+id+`++;

					if(icc`+id+` != 2 ) {

					return false;
				}

	            var fluidPlayer`+id+` = fluidPlayer("`+id+`", {
	                layoutControls: {
	                    primaryColor: false,
	                    playButtonShowing: true,
	                    playPauseAnimation: true,
	                    fillToContainer: false,
	                    autoPlay: false,
	                    preload: false,
	                    mute: true,
	                    doubleclickFullscreen: false,
	                    subtitlesEnabled: false,
	                    keyboardControl: true,
	                    layout: "default",
	                    allowDownload: false,
	                    playbackRateEnabled: false,
	                    allowTheatre: false,
	                    title: false,
	                    controlBar: {
	                        autoHide: false
	                    }
	                },
	                "vastOptions": {
	                    "allowVPAID": "true", 
	                    "adList": [
	                        {
	                            "roll": "preRoll",
	                            "vastTag": "`+ vid_delpath +`",
	                            "adClickable": "true"
	                        }
	                    ],
	                    vastAdvanced: {
	                        vastLoadedCallback:       (function() {}),
	                        noVastVideoCallback:      (function() {}),
	                        vastVideoSkippedCallback: (function() { 
	                            $("#rm_videowrapper`+id+`").slideUp(800);
	                            show_vid = 4; 
	                            tracking_event_`+id+`("skip"); 
	                            fluidPlayer`+id+`_run = 0;
	                        }),
	                        vastVideoEndedCallback:   (function() { 
	                            $("#rm_videowrapper`+id+`").slideUp(800);
	                            show_vid = 4; 
	                            tracking_event_`+id+`("complete"); 
	                            fluidPlayer`+id+`_run = 0;
	                        })
	                    }
	                }
	            });

        	    fluidPlayer`+id+`.on("pause", function(){ tracking_event_`+id+`("pause"); });
	            fluidPlayer`+id+`.on("theatreModeOn", function(){ tracking_event_`+id+`("fullscreen"); });
	            fluidPlayer`+id+`.on("theatreModeOff", function(){ tracking_event_`+id+`("exitfullscreen"); });
           
                setTimeout(function(){ 
                    fluidPlayer`+id+`.pause(); 
                },2000);
                
                var height`+id+` = $("#rm_videowrapper`+id+`").height();
                var width`+id+` = $("#rm_videowrapper`+id+`").width();

                var div_position`+id+` = $("#rm_videowrapper`+id+`").offset();
            	var visible_height`+id+` = height`+id+`/2;
                
                $("#rm_videowrapper`+id+`").hide();
                var show_vid`+id+` = 1;

                var visible_height`+id+` = height`+id+`/2;
                var user_pause`+id+` = 0;

                $("#`+id+`_fluid_control_playpause").click(function() {
                    (user_pause`+id+` == 0) ? user_pause`+id+` = 1 : user_pause`+id+` = 0;
                });
                var first_occuresce`+id+` = 0;

                $(window).scroll(function()
                {
                    var visible_height_up`+id+` = div_position`+id+`.top+(visible_height`+id+`);
                    var screen_height`+id+` = $(window).height();
                    var visible_height_down`+id+` = (div_position`+id+`.top+visible_height`+id+`)-screen_height`+id+`;
                    scroll_position`+id+` = $(window).scrollTop();

                    if(scroll_position`+id+` >= visible_height_up`+id+` || scroll_position`+id+` <= visible_height_down`+id+`)
                    {
                        fluidPlayer`+id+`.pause();
                    }
                    else
                    {
                        if(user_pause`+id+` == 0)
                        {
                            fluidPlayer`+id+`.play(); 	
                        }
                        
                        if(first_occuresce`+id+` == 0)
                        {
                            $("#rm_videowrapper`+id+`").slideDown(800);
                            first_occuresce`+id+` = 1;
                        }
                    }
                });

            	$(window).scroll();
         	}
                
    		</script> 
		</div>`

	}else if bnrParams["ad_type"] == "2" || bnrParams["vid_type"] == "External" { 

    		externalAdStyle = `<style>            
	            .video-js .vjs-time-control, .video-js .vjs-fullscreen-control, .video-js .vjs-progress-control
	            {
	                display: none;
	            }
	            
	            .video-js .vjs-time-control, .video-js .vjs-fullscreen-control, .video-js .vjs-progress-control
	            {
	                display: none;
	            }

	            @media only screen and (min-width: 10px) and (max-width: 299px)
	            {
	                #`+id+`
	                {
	                    height: 150px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 300px) and (max-width: 399px)
	            {
	                #`+id+`
	                {
	                    height: 200px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 400px) and (max-width: 650px)
	            {
	                #`+id+`
	                {
	                    height: 300px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 651px) and (max-width: 800px)
	            {
	                #`+id+`
	                {
	                    height: 400px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 801px) and (max-width: 1000px)
	            {
	                #`+id+`
	                {
	                    height: 500px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 1001px) and (max-width: 2000px)
	            {
	                #`+id+`
	                {
	                    height: 600px; 
	                    width: auto;  
	                }
	            }
	            @media only screen and (min-width: 2001px)
	                #`+id+`
	                {
	                    height: 700px; 
	                    width: auto; 
	                }
	            }

	       		</style>`
        

	
			adDetails.Html = `<link rel="stylesheet" href="` + config.GetConfig("protocol","webpath") + config.GetConfig("admin","webpath")+`/plugins/Outstream/delivery/fluid/fluidplayer.min.css" type="text/css">

			<script>
		
				if (typeof fluidplayer_scripts == 'undefined') 
				{
						var fluidplayer_scripts = [];
				}
	
	
				function loadScript(url,md5, callback)
				{
					if(fluidplayer_scripts.includes(md5) == false)
					{
					
					
				    var script = document.createElement("script");
				    script.type = "text/javascript";

				    if (script.readyState){ 
				        script.onreadystatechange = function(){
				            if (script.readyState == "loaded" ||
				                    script.readyState == "complete"){
				                script.onreadystatechange = null;
				                callback();

				            }
				        };
				    } else {  
				        script.onload = function(){
							callback();	
				        };
				    }

				    script.src = url;
				    document.getElementsByTagName("head")[0].appendChild(script);
				    
				    fluidplayer_scripts.push(md5);
					
					}
					else
					{
					setTimeout(function() {
						callback();
						}, 1000); 
					}
				    
					
					
				}

				loadScript("`+s+`","`+hex.EncodeToString(encs.Sum(nil))+`", function() {  load_ply_`+id+`()   }  );
				loadScript("`+s1+`","`+hex.EncodeToString(encs1.Sum(nil))+`", function() {  load_ply_`+id+`()   }  );
				</script>
				
				
				<style>   
				 .fluid_context_menu, .fluid_controls_left , .fluid_control_duration , .ad_countdown  ,.fluid_controls_progress_container
			{
			    display: none !important;

			}
			         
		            .video-js .vjs-time-control, .video-js .vjs-fullscreen-control, .video-js .vjs-progress-control
		            {
		                display: none;
		            }
		            
		            .video-js .vjs-time-control, .video-js .vjs-fullscreen-control, .video-js .vjs-progress-control
		            {
		                display: none;
		            }

		            @media only screen and (min-width: 10px) and (max-width: 299px)
		            {
		                #`+id+`
		                {
		                    height: 150px; 
		                    width: auto; 
		                }
		            }
		            @media only screen and (min-width: 300px) and (max-width: 399px)
		            {
		                #`+id+`
		                {
		                    height: 200px; 
		                    width: auto; 
		                }
		            }
		            @media only screen and (min-width: 400px) and (max-width: 650px)
		            {
		                #`+id+`
		                {
		                    height: 300px; 
		                    width: auto; 
		                }
		            }
		            @media only screen and (min-width: 651px) and (max-width: 800px)
		            {
		                #`+id+`
		                {
		                    height: 400px; 
		                    width: auto; 
		                }
		            }
		            @media only screen and (min-width: 801px) and (max-width: 1000px)
		            {
		                #`+id+`
		                {
		                    height: 500px; 
		                    width: auto; 
		                }
		            }
		            @media only screen and (min-width: 1001px) and (max-width: 2000px)
		            {
		                #`+id+`
		                {
		                    height: 600px; 
		                    width: auto;  
		                }
		            }
		            @media only screen and (min-width: 2001px)
		                #`+id+`
		                {
		                    height: 700px; 
		                    width: auto; 
		                }
		            }
					.fluid_context_menu, .fluid_controls_left , .fluid_control_duration , .ad_countdown  ,.fluid_controls_progress_container
					{
					    display: none !important;

					}
					
		        	#admedia`+rand1+` img
		        	{
		            	position: relative !important;
		        	}
		        	
		        	`+externalAdStyle+`
		        </style>
		        <div id="admedia`+rand1+`">
					<div class="rm_videowrapper`+id+`" id="rm_videowrapper`+id+`">
				        <div>
				            <div>
				                <div style="width: 5.667% !important;">

				                <img src="`+iconUrl+`" style="border-radius:50%;width:50px;height:50px;">
				                   
				                </div>
				                <div>
				                    <div>
				                        <h5 style="margin-left:2px;font-weight: normal;">`+title+`</h5>
				                    </div>
				                    <div>
				                        <h6 style="margin-left:10px; font-weight: bold;">`+sponser_text+`</h6>
				                    </div>
				                </div>
				            </div>
				        </div>
				        <div>
				            <div>
				                <div>
				                    <p style="font-size:15px!important; line-height:1.5 !important;">`+textDesc+`</p>
				                </div>
				            </div>
				        </div>
				        <div>
				            <div>
				                <video id="`+id+`"  autoplay="false" muted="muted">
				                    <source src="`+video_url+`" type="video/mp4">
				                </video>
				            </div>
				        </div>
				        <div>
				            <div style="text-align:center;margin-top:1%;">
				               <a type="button" href="`+destination_url+`" target="_blank" class="btn btn-info">`+cta_text+`</a>
				            </div>
				        </div>
			        </div>
		        </div>

          		<script> 
        
		    		function tracking_event_`+id+`(track_type) {
		                if(fluidPlayer`+id+`_run == 1) {
		        		var track_url = "`+config.GetConfig("protocol","webpath") + config.GetConfig("delivery","webpath")+`/fc.php?script=rmvideoAds:rmvastEvent&bannerid=`+strconv.Itoa(adDetails.Ad_id)+`&zoneid=`+strconv.Itoa(zn.Zoneid)+`&event="+track_type;

		                    $.ajax({
		                        type: "get",
		                        url: track_url,
		                        cache: false,
		                        success: function (json) {
		                            try { 
		                                console.log("Track event success");
		                            } catch (e) {
		                                console.log("Exception while request..");
		                            }
		                        },
		                        error: function () {
		                            console.log("Error while request..");
		                        }
		                    });
		                }
		            }

 
		            var fluidPlayer`+id+`_run = 1;  
		           
		            var icc`+id+` = 0;
				    function load_ply_`+id+`() {   
						icc`+id+`++;

						if(icc`+id+` != 2 ) {

						return false;
					}

		            var fluidPlayer`+id+` = fluidPlayer(
		                "`+id+`", {
		                layoutControls: {
		                    primaryColor: false,
		                    playButtonShowing: true,
		                    playPauseAnimation: true,
		                    fillToContainer: false,
		                    autoPlay: false,
		                    preload: false,
		                    mute: true,
		                    doubleclickFullscreen: false,
		                    subtitlesEnabled: false,
		                    keyboardControl: true,
		                    layout: "default",
		                    allowDownload: false,
		                    playbackRateEnabled: false,
		                    allowTheatre: false,
		                    title: false,
		                    controlBar: {
		                        autoHide: false
		                    }
		                },
		                "vastOptions": {
		                    "allowVPAID": "true", 
		                    "adList": [
		                        {
		                            "roll": "preRoll",
		                            "vastTag": "`+ vid_delpath +`",
		                            "adClickable": "true"
		                        }
		                    ],
		                    vastAdvanced: {
		                        vastLoadedCallback:       (function() {}),
		                        noVastVideoCallback:      (function() {}),
		                        vastVideoSkippedCallback: (function() { 
		                            $("#rm_videowrapper`+id+`").slideUp(800);
		                            show_vid = 4; 
		                            tracking_event_`+id+`("skip"); 
		                            fluidPlayer`+id+`_run = 0;
		                        }),
		                        vastVideoEndedCallback:   (function() { 
		                            $("#rm_videowrapper`+id+`").slideUp(800);
		                            show_vid = 4; 
		                            tracking_event_`+id+`("complete"); 
		                            fluidPlayer`+id+`_run = 0;
		                        })
		                    }
		                }
		            });

        
		            fluidPlayer`+id+`.on("play", function(){ tracking_event_`+id+`("resume"); });

		            fluidPlayer`+id+`.on("pause", function(){ tracking_event_`+id+`("pause"); });

		            fluidPlayer`+id+`.on("theatreModeOn", function(){ tracking_event_`+id+`("fullscreen"); });

		            fluidPlayer`+id+`.on("theatreModeOff", function(){ tracking_event_`+id+`("exitfullscreen"); });

           
	                setTimeout(function(){ 
	                    fluidPlayer`+id+`.pause(); 
	                },2000);
	                
	                var height`+id+` = $("#rm_videowrapper`+id+`").height();
	                var width`+id+` = $("#rm_videowrapper`+id+`").width();

	                var div_position`+id+` = $("#rm_videowrapper`+id+`").offset();
	                $("#rm_videowrapper`+id+`").hide();
	                var show_vid`+id+` = 1;

	                var visible_height`+id+` = height`+id+`/1.5;

	                var user_pause`+id+` = 0;

	                $("#`+id+`_fluid_control_playpause").click(function()
	                {
	                    (user_pause`+id+` == 0) ? user_pause`+id+` = 1 : user_pause`+id+` = 0;
	                });

	                $(window).scroll(function()
	                {
	                    var visible_height_up`+id+` = div_position`+id+`.top+(visible_height`+id+`);
	                    var screen_height`+id+` = $(window).height();
	                    var visible_height_down`+id+` = (div_position`+id+`.top+visible_height`+id+`)-screen_height`+id+`;


	                    scroll_position`+id+` = $(window).scrollTop();

	                    if(scroll_position`+id+` >= visible_height_up`+id+` || scroll_position`+id+` <= visible_height_down`+id+`)
	                    {
	                        if( show_vid`+id+` != 1)
	                        {
	                            fluidPlayer`+id+`.pause();
	                        }
	                    }
	                    else
	                    {
	                        if( show_vid`+id+` == 1 && user_pause`+id+` == 0)
	                        {
	                            $("#rm_videowrapper`+id+`").css("opacity","1");
	                            setTimeout( function()  
	                            { 
	                                $("#rm_videowrapper`+id+`").slideDown(800);
	                                show_vid`+id+` = 2 ;
	                                fluidPlayer`+id+`.play(); 
	                            },500);
	                        
	                        }
	                        else if(show_vid`+id+` == 2 && user_pause`+id+` == 0)
	                        {
	                            setTimeout( function()  { 
	                                fluidPlayer`+id+`.play(); 
	                                show_vid`+id+` = 3; 
	                            },500);
	                            
	                        }
	                        else if(show_vid`+id+` == 3 && user_pause`+id+` == 0)
	                        {
	                            fluidPlayer`+id+`.play();
	                        }
	                    }
	                });

                	$(window).scroll();

	                $("#rm_videowrapper`+id+`").mouseenter(function()
	                {
	                    tracking_event_`+id+`("unmute");
	                    fluidPlayer`+id+`.setVolume(0.5);
	                });

	                $("#rm_videowrapper`+id+`").mouseout(function()
	                {
	                    tracking_event_`+id+`("mute");
	                    fluidPlayer`+id+`.setVolume(0.5); 
	                }); 
	         	}
                
    		</script> 
		</div>`
		
		

	}else if bnrParams["ad_type"] == "3" || bnrParams["vid_type"] == "External" { 

    		externalAdStyle = `<style>            
	            .video-js .vjs-time-control, .video-js .vjs-fullscreen-control, .video-js .vjs-progress-control
	            {
	                display: none;
	            }
	            
	            .video-js .vjs-time-control, .video-js .vjs-fullscreen-control, .video-js .vjs-progress-control
	            {
	                display: none;
	            }

	            @media only screen and (min-width: 10px) and (max-width: 299px)
	            {
	                #`+id+`
	                {
	                    height: 150px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 300px) and (max-width: 399px)
	            {
	                #`+id+`
	                {
	                    height: 200px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 400px) and (max-width: 650px)
	            {
	                #`+id+`
	                {
	                    height: 300px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 651px) and (max-width: 800px)
	            {
	                #`+id+`
	                {
	                    height: 400px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 801px) and (max-width: 1000px)
	            {
	                #`+id+`
	                {
	                    height: 500px; 
	                    width: auto; 
	                }
	            }
	            @media only screen and (min-width: 1001px) and (max-width: 2000px)
	            {
	                #`+id+`
	                {
	                    height: 600px; 
	                    width: auto;  
	                }
	            }
	            @media only screen and (min-width: 2001px)
	                #`+id+`
	                {
	                    height: 700px; 
	                    width: auto; 
	                }
	            }

	       		</style>`
        

	
			adDetails.Html = `<link rel="stylesheet" href="` + config.GetConfig("protocol","webpath") + config.GetConfig("admin","webpath")+`/plugins/Outstream/delivery/fluid/fluidplayer.min.css" type="text/css">
				<script>
			


					if (typeof fluidplayer_scripts == 'undefined') 
					{
							var fluidplayer_scripts = [];
					}
		
		
					function loadScript(url,md5, callback)
					{
						if(fluidplayer_scripts.includes(md5) == false)
						{
						
						
					    var script = document.createElement("script");
					    script.type = "text/javascript";

					    if (script.readyState){ 
					        script.onreadystatechange = function(){
					            if (script.readyState == "loaded" ||
					                    script.readyState == "complete"){
					                script.onreadystatechange = null;
					                callback();

					            }
					        };
					    } else {  
					        script.onload = function(){
								callback();	
					        };
					    }

					    script.src = url;
					    document.getElementsByTagName("head")[0].appendChild(script);
					    
					    fluidplayer_scripts.push(md5);
						
						}
						else
						{
						setTimeout(function() {
							callback();
							}, 1000); 
						}
					    			
					}
					loadScript("`+s+`","`+hex.EncodeToString(encs.Sum(nil))+`", function() {  load_ply_`+id+`()   }  );
					loadScript("`+s1+`","`+hex.EncodeToString(encs1.Sum(nil))+`", function() {  load_ply_`+id+`()   }  );
				</script>

				<style>            
		            .video-js .vjs-time-control, .video-js .vjs-fullscreen-control, .video-js .vjs-progress-control
					{
						display: none;
					}  

					@media only screen and (min-width: 100px) and (max-width: 790px)
					{
						#rm_videowrapper`+id+`{
							margin-top: 50%;
						}

					}	

					@media only screen and (min-width: 10px) and (max-width: 299px)
					{
						#`+id+`
						{
							position: relative;
							margin-top: 50%;
				   			height: 150px; 
				   			width: auto; 
						};
					}

		            @media only screen and (min-width: 300px) and (max-width: 399px)
		            {
		                #`+id+`
		                {
		                	position: relative;
							margin-top: 50%;
		                    height: 200px; 
		                    width: auto; 
		                }
		            }
		            
		            @media only screen and (min-width: 400px) and (max-width: 650px)
		            {
		                #`+id+`
		                {
		                	position: relative;
							margin-top: 50%;
		                    height: 300px; 
		                    width: auto; 
		                }
		            }
		            
		            @media only screen and (min-width: 651px) and (max-width: 900px)
		            {
		                #`+id+`
		                {
		                    height: 400px; 
		                    width: auto; 
		                }
		            }
		            @media only screen and (min-width: 901px)
		            {
		                #`+id+`
		                {
		                    height: 400px; 
				   			width: auto; 
				   			margin-top: 20px;
		                }
		            }
		            @media only screen and (min-width: 100px) and (max-width: 980px)
		            {
		               	.volume_controls{
							position: relative;
							margin-top: -45px;
							float: left;
							left: 26%;
							z-index: 1;
							
						}
		            }
		            @media only screen and(min-width: 981px) and (max-width: 1080px)
		            {
		                .volume_controls{
							position: relative;
							margin-top: -45px;
							float: left;
							left: 28%;
							z-index: 1;
							
						}
		            }

		            @media only screen and (min-width: 1081px) and (max-width: 1420px)
					{
						.volume_controls{
							position: relative;
							margin-top: -45px;
							float: left;
							left: 32%;
							z-index: 1;
						}
					}

					@media only screen and (min-width: 1421px) and (max-width: 1560px)
					{
						.volume_controls{
							position: relative;
							margin-top: -45px;
							float: left;
							left: 35%;
							z-index: 1;
						}
					}

					@media only screen and (min-width: 1561px) and (max-width: 1825px)
					{
						.volume_controls{
							position: relative;
							margin-top: -45px;
							float: left;
							left: 37%;
							z-index: 1;
						}
					}

					@media only screen and (min-width: 1826px) 
					{
						.volume_controls{
							position: relative;
							margin-top: -45px;
							float: left;
							left: 42%;
							z-index: 1;
						}
					}
		
					.fluid_context_menu, .fluid_controls_left , .fluid_control_duration , .ad_countdown  ,.fluid_controls_progress_container
					{
					    display: none !important;

					}
    	
    				#rm_videowrapper`+id+`
					{
						margin-left: auto;
						margin-right: auto;
						width:  90%;
						height: 90%;
					}
					#intersitial_outstream`+id+`{
						position: fixed;
						z-index: 9999;
						background: rgba(0, 0, 0, 0.75);
						top: 0;
						    left: 0;

						width: 100%;
						height: 100%;
					}
					.text-white{
						color: #fff;
					}
					#interstitial-footer`+id+`{
						text-align : right;
						margin-left: 550px;
						padding-top: 10px;
					}
					
					
		        </style>

		        <div id="intersitial_outstream`+id+`">
					<div id="rm_videowrapper`+id+`">
						<center>
							<video id="`+id+`" autoplay="false" muted="muted" style="position: relative;"><source src="`+video_url+`" type="video/mp4"></video>
							<div class="interstitial-footer" id="interstitial-footer" >
						    	<button type="button" class="btn btn-primary" id="close_interstitial_ad`+id+`" data-dismiss="modal">Close</button>
						    </div>
						</center>
					</div>
				</div>

				<script> 
	    	var fluidPlayer`+id+`_run = 1;
	    	
	    	   function tracking_event_`+id+`(track_type) {
	        	if(fluidPlayer`+id+`_run == 1) {
        		var track_url = "`+config.GetConfig("protocol","webpath") + config.GetConfig("delivery","webpath")+`/fc.php?script=rmvideoAds:rmvastEvent&bannerid=`+strconv.Itoa(adDetails.Ad_id)+`&zoneid=`+strconv.Itoa(zn.Zoneid)+`&event="+track_type;

	        		$.ajax({
					    type: "get",
					    url: track_url,
					    cache: false,
					    success: function (json) {
					        try {
					        	console.log("Track event success");
					        } catch (e) {
					            console.log("Exception while request..");
					        }
					    },
					    error: function () {
					        console.log("Error while request..");
					    }
					});
	        	}
	        }
	        
	        
    	  	var icc`+id+` = 0;
     		function load_ply_`+id+`() {   
				icc`+id+`++;
				if(icc`+id+` != 2 ) {
					return false;
				}	  	
		  	

	    	var fluidPlayer`+id+` = fluidPlayer("`+id+`", {
	    		layoutControls: {
		            primaryColor:           false,
		            playButtonShowing:      true,
		            playPauseAnimation:     true,
		            fillToContainer:        false,
		            autoPlay:               false,
		            preload:                false,
		            mute:                   true,
		            doubleclickFullscreen:  true,
		            subtitlesEnabled:       false,
		            keyboardControl:        true,
		            layout:                 "default",
		            allowDownload:          false,
		            playbackRateEnabled:    false,
		            allowTheatre:           true,
		            title:                  false,
		            controlBar: {
		                autoHide:           false
		            }
		        },
	            "vastOptions": {
	            	maxAllowedVastTagRedirects: 1,
	                "allowVPAID": "true",
	                "adList": [
	                    {
	                        "roll": "preRoll",
	                        "vastTag": "`+vid_delpath+`",
	                        adClickable: true
	                    }
	                ],
	                vastAdvanced: {
	                	vastLoadedCallback:       (function() {}),
	                	noVastVideoCallback:      (function() {}),
		                vastVideoSkippedCallback: (function() { 
		                	$("#intersitial_outstream").slideUp(800);
		                	show_vid = 4;
		                	tracking_event_`+id+`("skip"); 
		                	fluidPlayer`+id+`_run = 0; 
		                }),
		                vastVideoEndedCallback:   (function() { 
		                	$("#intersitial_outstream").slideUp(800);
		                	show_vid = 4; 
		                	tracking_event_`+id+`("complete"); 
		                	fluidPlayer`+id+`_run = 0;
		                })
		            }
	            }
	        });

	     

	        fluidPlayer`+id+`.on("play", function(){ tracking_event_`+id+`("resume"); });
	        fluidPlayer`+id+`.on("pause", function(){ tracking_event_`+id+`("pause"); });
	        fluidPlayer`+id+`.on("theatreModeOn", function(){ tracking_event_`+id+`("fullscreen"); });
	        fluidPlayer`+id+`.on("theatreModeOff", function(){ tracking_event_`+id+`("exitfullscreen"); });

			
			
		
			fluidPlayer`+id+`.play();


			fluidPlayer`+id+`.on("ended", function()
			{	  
    			close_vid`+id+`();				
			});
	     

	        $("#close_interstitial_ad`+id+`").click(function(){
	        	close_vid`+id+`();
	        });

			}

	        function close_vid`+id+`()
	        {
	        	$("#intersitial_outstream`+id+`").slideUp(1000);
	        }     
	    </script>`

	}else if bnrParams["ad_type"] == "4"{ //Infeed

		adDetails.Html = `<link rel="stylesheet" href="` + config.GetConfig("protocol","webpath") + config.GetConfig("admin","webpath")+`/plugins/Outstream/delivery/fluid/fluidplayer.min.css" type="text/css"/>
		<script>
		
			if (typeof fluidplayer_scripts == 'undefined')  {
					var fluidplayer_scripts = [];
			}

			function loadScript(url,md5, callback)
			{
				if(fluidplayer_scripts.includes(md5) == false)
				{
			    var script = document.createElement("script");
			    script.type = "text/javascript";

			    if (script.readyState){ 
			        script.onreadystatechange = function(){
			            if (script.readyState == "loaded" ||
			                    script.readyState == "complete"){
			                script.onreadystatechange = null;
			                callback();

			            }
			        };
			    } else {  
			        script.onload = function(){
						callback();	
			        };
			    }

			    script.src = url;
			    document.getElementsByTagName("head")[0].appendChild(script);
			    
			    fluidplayer_scripts.push(md5);
				
				}
				else
				{
				setTimeout(function() {
					callback();
					}, 1000); 
				}
			}
			loadScript("`+s+`","`+hex.EncodeToString(encs.Sum(nil))+`", function() {  load_ply_`+id+`()   }  );
			loadScript("`+s1+`","`+hex.EncodeToString(encs1.Sum(nil))+`", function() {  load_ply_`+id+`()   }  );
		</script>
		<style>
			.video-js .vjs-time-control, .video-js .vjs-fullscreen-control, .video-js .vjs-progress-control
			{
				display: none;
			}
			@media only screen and (min-width: 10px) and (max-width: 299px)
			{
				#`+id+`
				{
		   			height: 150px; 
		   			width: auto; 
				}
			}
			@media only screen and (min-width: 300px) and (max-width: 399px)
			{
				#`+id+`
				{
		   			height: 200px; 
		   			width: auto; 
				}
			}
			@media only screen and (min-width: 400px) and (max-width: 650px)
			{
				#`+id+`
				{
		   			height: 300px; 
		   			width: auto; 
				}
			}
			@media only screen and (min-width: 651px) and (max-width: 800px)
			{
				#`+id+`
				{
		   			height: 400px; 
		   			width: auto; 
				}
			}
			@media only screen and (min-width: 801px) and (max-width: 1000px)
			{
				#`+id+`
				{
		   			height: 500px; 
		   			width: auto; 
				}
			}
			@media only screen and (min-width: 1001px) and (max-width: 2000px)
			{
				#`+id+`
				{
		   			height: 600px; 
		   			width: auto; 
				}
			}
			@media only screen and (min-width: 2001px)
				#`+id+`
				{
		   			height: 700px; 
		   			width: auto; 
				}
			}
		</style>
		<div id="test-ad`+rand1+`">
		   	<style>
          		.fluid_context_menu, .fluid_controls_left , .fluid_control_duration , .ad_countdown  ,.fluid_controls_progress_container
				{
				    display: none !important;

				} 
            	.admedia`+rand1+` img
            	{
                	position: relative !important;
            	}           	
            	
            </style>
	        <div class="admedia`+rand1+`" >
				<center>
					<div id="outstream`+id+`" style="background-color: white;" >
						<video id="`+id+`" autoplay="false" muted="muted" style="position: relative;">	 
							<source src="`+video_url+`" type="video/mp4">	
						</video>
					</div>
				</center>
			</div>
		</div>

    	<script> 
		   var fluidPlayer`+id+`_run = 1;
         
        
        	function tracking_event_`+id+`(track_type) {
    			if(fluidPlayer`+id+`_run == 1) {
    				var track_url = "`+config.GetConfig("protocol","webpath") + config.GetConfig("delivery","webpath")+`/fc.php?script=rmvideoAds:rmvastEvent&bannerid=`+strconv.Itoa(adDetails.Ad_id)+`&zoneid=`+strconv.Itoa(zn.Zoneid)+`&event="+track_type;

        			$.ajax({
					    type: "get",
					    url: track_url,
					    cache: false,
					    success: function (json) {
					        try {
					        	console.log("Track event success");
					        } catch (e) {
					            console.log("Exception while request..");
					        }
					    },
					    error: function () {
					        console.log("Error while request..");
					    }
					});
	        	}
        	}

     		var fluidPlayer`+id+`_run = 1;   
            
    		var icc`+id+` = 0;
 			function load_ply_`+id+`() {   
				icc`+id+`++;
				if(icc`+id+` != 2 ) {
					return false;
				}  	
	    		var fluidPlayer`+id+` = fluidPlayer("`+id+`", {
    				layoutControls: {
			            primaryColor:           false,
			            playButtonShowing:      true,
			            playPauseAnimation:     true,
			            fillToContainer:        false,
			            autoPlay:               false,
			            preload:                false,
			            mute:                   true,
			            doubleclickFullscreen:  true,
			            subtitlesEnabled:       false,
			            keyboardControl:        true,
			            layout:                 "default",
			            allowDownload:          false,
			            playbackRateEnabled:    false,
			            allowTheatre:           true,
			            title:                  false,
			            controlBar: {
			                autoHide:           false
			            }
			        },
		            "vastOptions": {
		            	maxAllowedVastTagRedirects: 1,
		                "allowVPAID": "true", 
		                "adList": [
		                    {
		                        "roll": "preRoll",
		                        "vastTag": "`+vid_delpath+`",
		                        adClickable: true
		                    }
		                ],
                		vastAdvanced: {
                			vastLoadedCallback: (function() {}),
                			noVastVideoCallback: (function() {}),
	                		vastVideoSkippedCallback: (function() { 
                				$("#outstream`+id+`").slideUp(800);
	                			show_vid = 4;
	                			tracking_event_`+id+`("skip"); 
	                			fluidPlayer`+id+`_run = 0; 
                			}),
	                		vastVideoEndedCallback: (function() { 
	                			$("#outstream`+id+`").slideUp(800);
	                			show_vid = 4;
	                			tracking_event_`+id+`("complete"); 
	                			fluidPlayer`+id+`_run = 0; 
                			})
	            		}
            		}
        		});

		        fluidPlayer`+id+`.on("play", function(){ tracking_event_`+id+`("resume"); });
		        fluidPlayer`+id+`.on("pause", function(){ tracking_event_`+id+`("pause"); });
		        fluidPlayer`+id+`.on("theatreModeOn", function(){ tracking_event_`+id+`("fullscreen"); });
		        fluidPlayer`+id+`.on("theatreModeOff", function(){ tracking_event_`+id+`("exitfullscreen"); });

				setTimeout(function(){ 
					fluidPlayer`+id+`.pause(); 
				},2000);

				var height`+id+` = $("#outstream`+id+`").height();
				var width`+id+`  = $("#outstream`+id+`").width();

				var div_position`+id+` = $("#outstream`+id+`").offset();
				var visible_height`+id+` = height`+id+`/2;

				$("#outstream`+id+`").css("opacity","0");
				$("#outstream`+id+`").hide(-9000);
				
				var show_vid`+id+` = 1;

				var user_pause`+id+` = 0;

				$("#`+id+`_fluid_control_playpause").click(function()  {
					(user_pause`+id+` == 0) ? user_paus`+id+` = 1 : user_pause`+id+` = 0;
				});
			
				$(window).scroll(function()
				{ 					
					var visible_height_up`+id+` = div_position`+id+`.top+(visible_height`+id+`);
					var screen_height`+id+` = $(window).height();
					var visible_height_down`+id+` = (div_position`+id+`.top+visible_height`+id+`)-screen_height`+id+`;

					scroll_position`+id+` = $(window).scrollTop();

					if(scroll_position`+id+` >= visible_height_up`+id+` || scroll_position`+id+` <= visible_height_down`+id+`)
					{
						if( show_vid`+id+` != 1)
						{
							fluidPlayer`+id+`.pause();
						}
					}
					else
					{

						if( show_vid`+id+` == 1 && user_pause`+id+` == 0)
						{
							$("#outstream`+id+`").css("opacity","1");
							$("#outstream`+id+`").slideDown(800);
							show_vid`+id+` = 2 ;
							fluidPlayer`+id+`.play();
						}
						else if(show_vid`+id+` == 2 && user_pause`+id+` == 0)
						{
							fluidPlayer`+id+`.play();
						}
					}
				});

				$(window).scroll();

				$("#outstream`+id+`").mouseenter(function()
				{
					tracking_event_`+id+`("unmute");
				    fluidPlayer`+id+`.setVolume(0.5); 
				});

				$("#outstream`+id+`").mouseout(function()
				{
					tracking_event_`+id+`("mute");
				    fluidPlayer`+id+`.setVolume(0); 
				});
			}
		</script>` 
	}else if bnrParams["ad_type"] == "5"{ //In banner
		var bg_width, bg_height, inbwidth, inbheight, button_height, button_width, desc_top, font_size, button_left, rm_wrappertop string
		zone_size := helper.GetUrlParam(r,"zone_size")

		if (zone_size == "1" && zone_size != "0") {
			bg_width  = "300"
			bg_height = "250"
			inbwidth  = "250"
			inbheight = "160"
			button_height = "25"
			button_width = "250"
			desc_top = "164"
			font_size = "12.5"
			button_left= "24"
			rm_wrappertop = "20"

		}else if(zone_size == "2"){
			bg_width  = "160"
			bg_height = "600"
			inbwidth  = "110"
			inbheight = "300"
			button_width = "110"
			button_height = "25"
			font_size = "12.5"
			button_left= "24"
			rm_wrappertop = "22"
		}else if (zone_size == "3"){
			bg_width  = "728"
			bg_height = "90"
			inbwidth  = "654"
			inbheight = "70"
			button_width = "100"
			button_height = "15"
			desc_top = "72"
			font_size = "7.5"
			button_left= "314"
			rm_wrappertop = "2"
		}else{
			bg_width  = "300"
			bg_height = "250"
			inbwidth  = "250"
			inbheight = "160"
			button_height = "25"
			button_width = "250"
			desc_top = "164"
			font_size = "12.5"
			button_left= "24"
			rm_wrappertop = "20"
		}

		adDetails.Html = `<link rel="stylesheet" href="` + config.GetConfig("protocol","webpath") + config.GetConfig("admin","webpath")+`/plugins/Outstream/delivery/fluid/fluidplayer.min.css" type="text/css"/>
		<script>
		
			if (typeof fluidplayer_scripts == 'undefined')  {
					var fluidplayer_scripts = [];
			}


			function loadScript(url,md5, callback)
			{
				if(fluidplayer_scripts.includes(md5) == false)
				{
			    var script = document.createElement("script");
			    script.type = "text/javascript";

			    if (script.readyState){ 
			        script.onreadystatechange = function(){
			            if (script.readyState == "loaded" ||
			                    script.readyState == "complete"){
			                script.onreadystatechange = null;
			                callback();

			            }
			        };
			    } else {  
			        script.onload = function(){
						callback();	
			        };
			    }

			    script.src = url;
			    document.getElementsByTagName("head")[0].appendChild(script);
			    
			    fluidplayer_scripts.push(md5);
				
				}
				else
				{
				setTimeout(function() {
					callback();
					}, 1000); 
				}
			}
			
			loadScript("`+s+`","`+hex.EncodeToString(encs.Sum(nil))+`", function() {  load_ply_`+id+`();   }  );
			loadScript("`+s1+`","`+hex.EncodeToString(encs1.Sum(nil))+`", function() {  load_ply_`+id+`();   }  );
		</script>
		<style>
				.video-js .vjs-time-control, .video-js .vjs-fullscreen-control, .video-js .vjs-progress-control
				{
					display: none;
				}
			
				#`+id+`
				{
		   			width: `+inbwidth+`px; 
		   			height: `+inbheight+`px; 
				}

				#demo_vid`+id+`
				{
					width :`+bg_width+`px; 
					height:`+bg_height+`px;
					margin-bottom:5px!important;
				}
				#rm_description`+id+`
				{
					line-height: `+button_height+`px; 
					font-size: `+font_size+`px; 
					font-style: italic;
					color: black;
					position: absolute; 
					background: white; 
					width: `+button_width+`px; 
					height: `+button_height+`px; 
					top: `+desc_top+`px;
					left: `+button_left+`px;
				}

				#rm_videowrapper`+id+`
				{
					position: relative; 
					top: `+rm_wrappertop+`%;
				}
				#rm_inbannerbg`+id+`
				{
					width: `+bg_width+`px!important;
					height: `+bg_height+`px!important;
				}
							
 
			</style>
			<div id="test-ad`+rand1+`">
		   <style>
		   
			.fluid_context_menu, .fluid_controls_left , .fluid_control_duration , .ad_countdown  ,.fluid_controls_progress_container
			{
			    display: none !important;

			} 
            	.ad-media`+rand1+` img
            	{
                	position: relative !important;
            	}
            </style>
            
	        <div class="ad-media`+rand1+`" >
			<div id="demo_vid`+id+`" style="margin-bottom:10px;">

				<center><span style="font-size:12px;">ADVERTISEMENT</span></center>
				<div style="position: absolute;">
					<img id="rm_inbannerbg`+id+`" src=`+bg_image+`>
				</div>
				<div id="rm_videowrapper`+id+`">

				<center>
					<video id="`+id+`" autoplay="false" muted="muted">
						<source src="`+video_url+`" type="video/mp4">
					</video>

					<a id="rm_clickurl`+id+`" target="'.$dest.'" href="`+destination_url+`">
						<span id="rm_description`+id+`">Click Here!</span>
					</a>

				</center>
				</div>
			</div>
			</div>
		</div>

   
 
		<script> 
			function tracking_event_`+id+`(track_type) {
	        	if(fluidPlayer`+id+`_run == 1) {
	        	
        		var track_url = "`+config.GetConfig("protocol","webpath") + config.GetConfig("delivery","webpath")+`/fc.php?script=rmvideoAds:rmvastEvent&bannerid=`+strconv.Itoa(adDetails.Ad_id)+`&zoneid=`+strconv.Itoa(zn.Zoneid)+`&event="+track_type;

	        		$.ajax({
					    type: "get",
					    url: track_url,
					    cache: false,
					    success: function (json) {
					        try {
					        	console.log("Track event success");
					        } catch (e) {
					            console.log("Exception while request..");
					        }
					    },
					    error: function () {
					        console.log("Error while request..");
					    }
					});
	        	}
	        }
	        
	        fluidPlayer`+id+`_run = 0;
	        
	        var icc`+id+` = 0;
		    function load_ply_`+id+`() {   
				icc`+id+`++;
				if(icc`+id+` != 2 ) {
					return false;
				}

        		var fluidPlayer`+id+`_run = 1;

				var playerId`+id+` = "`+id+`";

				var options`+id+` = {
		    		layoutControls: {
		    			posterImage: "`+bg_image+`",
			            primaryColor: false,
			            playButtonShowing: false,
			            playPauseAnimation: false,
			            fillToContainer: false,
			            autoPlay: false,
			            preload: false,
			            mute: false,
			            doubleclickFullscreen: true,
			            subtitlesEnabled: false,
			            keyboardControl: false,
			            layout: "default",
			            allowDownload: false,
			            playbackRateEnabled: false,
			            allowTheatre: false,
			            title: false,
			            controlBar: {
			                autoHide: false
			            },
			          
						playerInitCallback: (function() {
				        	$("#`+id+`_fluid_control_volume_container").hide(); 
							$("#`+id+`_fluid_control_duration").hide(); 
							$("#`+id+`_fluid_control_fullscreen").hide();
			        	})
			        },
		            "vastOptions": {
		            	maxAllowedVastTagRedirects: 1,
		                "allowVPAID": "true", 
		                "adList": [
		                    {
		                        "roll": "preRoll",
		                        "vastTag": "`+vid_delpath+`",
		                        adClickable: true
		                    }
		                ],
		                vastAdvanced: {
		                	vastLoadedCallback: (function() {
		                		videoVAST = jQuery("#`+id+`").attr("src");
		                		$("#`+id+`").trigger("pause");	
	                		}),
	                		
		                	noVastVideoCallback:(function() {}),
			                vastVideoSkippedCallback:(function() {
			                	fpDestroy(playerId`+id+`);
			                	tracking_event_`+id+`("skip"); 
			                	fluidPlayer`+id+`_run = 0; 
		                	}),

			                vastVideoEndedCallback:(function() {
			                	$("#`+id+`").attr("src", videoVAST);
			                	tracking_event_`+id+`("complete"); 
			                	fluidPlayer`+id+`_run = 0;
								setTimeout(function(){
									$("#`+id+`").trigger("pause");
								},1000);	
		                	})
			            }
		            }
		        };

		        var fpDestroy = function(idVideoPlayer) {
	                for (var i = 0; i < fluidPlayerClass.instances.length; i++) {
	                    if (fluidPlayerClass.instances[i].videoPlayerId === idVideoPlayer) {
	                        var videoWrapper = document.getElementById("fluid_video_wrapper_" + idVideoPlayer);
	                        var oldPlayer = document.getElementById(idVideoPlayer);
	                        var newPlayer = oldPlayer.cloneNode(true);
	                        videoWrapper.innerHTML = "";
	                        newPlayer.removeAttribute("src");
	                        videoWrapper.parentNode.replaceChild(newPlayer, videoWrapper);
	                        videoWrapper = null;
	                        oldPlayer = null;

	                        fluidPlayerClass.instances[i] = {videoPlayerId: "83748374hjkehwkfjrweqh8724983278983k"};

	                        break;
	                    } 
	                }
	            }; 

	            var myFP`+id+` = fluidPlayer(
	                playerId`+id+`,
	                options`+id+`
	             );


		        myFP`+id+`.on("play", function(){
	            	$("#`+id+`_fluid_controls_progress_container").hide();  
	        		$("#skip_button_`+id+`").hide();
	        		tracking_event_`+id+`("resume"); 	
	         	});

		        myFP`+id+`.on("pause", function(){ tracking_event_`+id+`("pause"); });

		        myFP`+id+`.on("theatreModeOn", function(){ tracking_event_`+id+`("fullscreen"); });

		        myFP`+id+`.on("theatreModeOff", function(){ tracking_event_`+id+`("exitfullscreen"); });

				setTimeout(function(){ 
					myFP`+id+`.pause(); 
				},2000);

				var div_position = $("#demo_vid`+id+`").offset();
				var height = $("#demo_vid`+id+`").height();
				var visible_height = height/1.5;
				var first_occuresce = 0;

				var user_pause = 0;

				$(window).scroll(function()
				{
					if(first_occuresce == 0)
					{
						var visible_height_up = div_position.top+(visible_height);
						var screen_height = $(window).height();
						var visible_height_down = (div_position.top+visible_height)-screen_height;


						scroll_position = $(window).scrollTop();

						if(scroll_position >= visible_height_up || scroll_position <= visible_height_down)
						{
							myFP`+id+`.pause();
						} else {
							myFP`+id+`.play();
						}
					}
				});

				$(window).scroll();
			}
			
			
		</script>` 
	}else { 
		adDetails.Html = ``
	}

		
		
}

func AdRenderOutstreamVideoAdSDK(adDetails *structure.AdDetails, zn structure.ZoneInfo,r *http.Request) {
	
	var clickurl string
	
	if adDetails.Url !=""  {
	clickurl = config.GetConfig( "protocol","webpath") + config.GetConfig("delivery","webpath") + "/ck.php?oaparams=2__bannerid=" + strconv.Itoa(adDetails.Ad_id) + "__campaignid=" + strconv.Itoa(adDetails.Placement_id) + "__zoneid="+ strconv.Itoa(zn.Zoneid)+"__oadest=" + adDetails.Url
	}
	
	impurl := config.GetConfig("protocol","webpath") + config.GetConfig("delivery","webpath") + "/lg.php?bannerid=" + strconv.Itoa(adDetails.Ad_id) + "&amp;campaignid=" + strconv.Itoa(adDetails.Placement_id) + "&amp;zoneid=" + strconv.Itoa(zn.Zoneid)
	
	
	adDetails.Imp_url = impurl
	adDetails.Click_url = clickurl
	
	
	adDetails.Html = vastXml(adDetails, zn)

		
}



func vastXml(adDetails *structure.AdDetails, zn structure.ZoneInfo) (xmlresponse string){
	
	
	zoneid := strconv.Itoa(zn.Zoneid)
	adid := strconv.Itoa(adDetails.Ad_id)
	campaign_id := strconv.Itoa(adDetails.Placement_id)
	clickurl := ""
	var video_url,ext_type, video_skip, delivery string 

	fcpath := config.GetConfig("protocol","webpath") + config.GetConfig("admin","webpath")+ `/plugins/Outstream/delivery/fc.php`
	
	var bnrParams  map[interface{}]interface{}
	phpserialize.Unmarshal([]byte(adDetails.Parameters), &bnrParams)

	if(adDetails.Url != ""){
		clickurl = config.GetConfig("protocol","webpath") + config.GetConfig("delivery","webpath")+ `/ck.php?oaparams=2__bannerid=`+adid+`__zoneid=`+zoneid+`__cb=7834046c99__oadest=`+ adDetails.Url
	}	
	
	logurl := config.GetConfig("protocol","webpath") + config.GetConfig("delivery","webpath")+ `/lg.php?bannerid=`+adid+`&campaignid=`+campaign_id+`&zoneid=`+zoneid

	if bnrParams["vid_upload_type"] == "External"{
		video_url = bnrParams["video_url"].(string)
	}else if bnrParams["vid_upload_type"] == "Internal"{
		video_url = config.GetConfig("protocol","webpath") + config.GetConfig("images","webpath") + bnrParams["rm_video"].(string)
	}else{
		video_url = config.GetConfig("protocol","webpath") + config.GetConfig("admin","webpath")+`/plugins/Outstream/delivery/js/videoplayback.mp4`
	}

	if(bnrParams["extension_type"]!="HLS") {
		delivery ="progressive" 
		ext_type = "video/mp4"

	}else {
		delivery ="streaming"
		ext_type = "application/x-mpegURL"
	}

	if(bnrParams["skip"].(string) != "") {
		video_skip = bnrParams["skip"].(string)

	}else {
		video_skip = "00:00:30"
	}

	if bnrParams["vid_type"] == "Internal" {
		xmlresponse = `<?xml version="1.0" encoding="UTF-8"?><VAST version="3.0"><configuration><system.webServer><httpProtocol><customHeaders><add name="Access-Control-Allow-Origin"/></customHeaders></httpProtocol></system.webServer></configuration><Ad id="`+zoneid+`"><InLine><AdSystem><![CDATA[Reviveadservermod.com]]></AdSystem><AdTitle><![CDATA[Vast 3.0]]></AdTitle><Pricing><model><![CDATA[CPM]]></model><currency><![CDATA[USD]]></currency></Pricing><Impression><![CDATA[`+logurl+`]]></Impression><Impression><![CDATA[http://www.djaxadserver.com/]]></Impression><Creatives><Creative><Linear skipoffset="`+video_skip+`"><TrackingEvents><Tracking event="start"><![CDATA[`+fcpath+`?script=rmvideoAds:rmvastEvent&bannerid=`+adid+`&zoneid=`+zoneid+`&event=start]]></Tracking><Tracking event="firstQuartile"><![CDATA[`+fcpath+`?script=rmvideoAds:rmvastEvent&bannerid=`+adid+`&zoneid=`+zoneid+`&event=firstquartile]]></Tracking><Tracking event="midpoint"><![CDATA[`+fcpath+`?script=rmvideoAds:rmvastEvent&bannerid=`+adid+`&zoneid=`+zoneid+`&event=midpoint]]></Tracking><Tracking event="thirdQuartile"><![CDATA[`+fcpath+`?script=rmvideoAds:rmvastEvent&bannerid=`+adid+`&zoneid=`+zoneid+`&event=thirdquartile]]></Tracking><Tracking event="complete"><![CDATA[`+fcpath+`?script=rmvideoAds:rmvastEvent&bannerid=`+adid+`&zoneid=`+zoneid+`&event=complete]]></Tracking><Tracking event="pause"><![CDATA[`+fcpath+`?script=rmvideoAds:rmvastEvent&bannerid=`+adid+`&zoneid=`+zoneid+`&event=pause]]></Tracking><Tracking event="mute"><![CDATA[`+fcpath+`?script=rmvideoAds:rmvastEvent&bannerid=`+adid+`&zoneid=`+zoneid+`&event=mute]]></Tracking><Tracking event="fullscreen"><![CDATA[`+fcpath+`?script=rmvideoAds:rmvastEvent&bannerid=`+adid+`&zoneid=`+zoneid+`&event=fullscreen]]></Tracking><Tracking event="unmute"><![CDATA[`+fcpath+`?script=rmvideoAds:rmvastEvent&bannerid=`+adid+`&zoneid=`+zoneid+`&event=unmute]]></Tracking><Tracking event="closeLinear"><![CDATA[`+fcpath+`?script=rmvideoAds:rmvastEvent&bannerid=`+adid+`&zoneid=`+zoneid+`&event=closeLinear]]></Tracking><Tracking event="acceptInvitationLinear"><![CDATA[`+fcpath+`?script=rmvideoAds:rmvastEvent&bannerid=`+adid+`&zoneid=`+zoneid+`&event=acceptInvitationLinear]]></Tracking><Tracking event="skip"><![CDATA[`+fcpath+`?script=rmvideoAds:rmvastEvent&bannerid=`+adid+`&zoneid=`+zoneid+`&event=skip]]></Tracking><Tracking event="progress" offset="00:00:10"><![CDATA[`+fcpath+`?script=rmvideoAds:rmvastEvent&bannerid=`+adid+`&zoneid=`+zoneid+`&event=progress]]></Tracking><Tracking event="exitFullscreen"><![CDATA[`+fcpath+`?script=rmvideoAds:rmvastEvent&bannerid=`+adid+`&zoneid=`+zoneid+`&event=exitfullscreen]]></Tracking><Tracking event="rewind"><![CDATA[`+fcpath+`?script=rmvideoAds:rmvastEvent&bannerid=`+adid+`&zoneid=`+zoneid+`&event=rewind]]></Tracking><Tracking event="resume"><![CDATA[`+fcpath+`?script=rmvideoAds:rmvastEvent&bannerid=`+adid+`&zoneid=`+zoneid+`&event=resume]]></Tracking></TrackingEvents><VideoClicks><ClickThrough>`+clickurl+`</ClickThrough></VideoClicks><MediaFiles><MediaFile delivery="`+delivery+`" bitrate="400" width="640" height="480" type="`+ext_type+`" scalable="true" maintainAspectRatio="true"><![CDATA[`+video_url+`]]></MediaFile></MediaFiles></Linear></Creative></Creatives></InLine></Ad></VAST>`
	}else if bnrParams["vid_type"] == "External" {
		xmlresponse = `<VAST xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' version='3.0' xsi:noNamespaceSchemaLocation='vast.xsd'><Ad id='`+zoneid+`'><Wrapper><AdSystem><![CDATA[ Revive Adserver ]]></AdSystem><AdTitle><![CDATA[ inline thirdparty ]]></AdTitle><Impression><![CDATA[`+logurl+`]]></Impression><VASTAdTagURI><![CDATA[`+video_url+`]]></VASTAdTagURI><Creatives><Creative><Linear><Duration/><TrackingEvents><Tracking event='start'><![CDATA[`+fcpath+`?script=videoAds:vastEvent&bannerid=6&zoneid=6&event=start]]></Tracking><Tracking event='firstQuartile'><![CDATA[`+fcpath+`?script=videoAds:vastEvent&bannerid=6&zoneid=6&event=firstquartile]]></Tracking><Tracking event='midpoint'><![CDATA[`+fcpath+`?script=videoAds:vastEvent&bannerid=6&zoneid=6&event=midpoint]]></Tracking><Tracking event='thirdQuartile'><![CDATA[`+fcpath+`?script=videoAds:vastEvent&bannerid=6&zoneid=6&event=thirdquartile]]></Tracking><Tracking event='complete'><![CDATA[`+fcpath+`?script=videoAds:vastEvent&bannerid=6&zoneid=6&event=complete]]></Tracking><Tracking event='pause'><![CDATA[`+fcpath+`?script=videoAds:vastEvent&bannerid=6&zoneid=6&event=pause]]></Tracking><Tracking event='mute'><![CDATA[`+fcpath+`?script=videoAds:vastEvent&bannerid=6&zoneid=6&event=mute]]></Tracking><Tracking event='fullscreen'><![CDATA[`+fcpath+`?script=videoAds:vastEvent&bannerid=6&zoneid=6&event=fullscreen]]></Tracking><Tracking event='unmute'><![CDATA[`+fcpath+`?script=videoAds:vastEvent&bannerid=6&zoneid=6&event=unmute]]></Tracking><Tracking event='creativeView'><![CDATA[`+fcpath+`?script=videoAds:vastEvent&bannerid=6&zoneid=6&event=creativeView]]></Tracking><Tracking event='acceptInvitationLinear'><![CDATA[`+fcpath+`?script=videoAds:vastEvent&bannerid=6&zoneid=6&event=acceptInvitationLinear]]></Tracking><Tracking event='closeLinear'><![CDATA[`+fcpath+`?script=videoAds:vastEvent&bannerid=6&zoneid=6&event=closeLinear]]></Tracking><Tracking event='skip'><![CDATA[`+fcpath+`?script=videoAds:vastEvent&bannerid=6&zoneid=6&event=skip]]></Tracking><Tracking event='progress' offset='00:00:09'><![CDATA[`+fcpath+`?script=videoAds:vastEvent&bannerid=6&zoneid=6&event=progress]]></Tracking><Tracking event='exitFullscreen'><![CDATA[`+fcpath+`?script=videoAds:vastEvent&bannerid=6&zoneid=6&event=exitfullscreen]]></Tracking><Tracking event='rewind'><![CDATA[`+fcpath+`?script=videoAds:vastEvent&bannerid=6&zoneid=6&event=rewind]]></Tracking><Tracking event='resume'><![CDATA[`+fcpath+`?script=videoAds:vastEvent&bannerid=6&zoneid=6&event=resume]]></Tracking></TrackingEvents>`+clickurl+`</Linear></Creative></Creatives></Wrapper></Ad></VAST>`
	}else{
		xmlresponse = ``
	}
	
	return xmlresponse
}




type NativeExtnal struct {
	Native struct {
		Asset []struct {
			ID    int `json:"id"`
			Title struct {
				Text string `json:"text,omitempty"`
			} `json:"title,omitempty"`
			Img struct {
				URL string `json:"url,omitempty"`
			} `json:"img,omitempty"`
			Data struct {
				Value string `json:"value,omitempty"`
			} `json:"data,omitempty"`
		} `json:"asset"`
		Link struct {
			URL string `json:"url,omitempty"`
		} `json:"link,omitempty"`
		Imptrackers []string `json:"imptrackers,omitempty"`
	} `json:"native,omitempty"`
	
	
}



func ExtenalNativeRender(znextra structure.AdExchangeZone , adm string) string  {
		

	 adm_res :=  NativeExtnal{}
	 
	 var adTextStyle, adTextHeader, adTextBody, adTextFooter string   
	var title, logo, image, image_width,image_height string
	var do_sponsored,do_description,do_ratting,do_likes,do_download,do_sales_price,do_original_price string     
	var do_phone,do_description2,do_address,do_display_url,do_cta string     
	var clickTag_start ,clickTag_end , impression string;
	   
	   
	   var native_ob map[interface{}]interface{}
		phpserialize.Unmarshal([]byte(znextra.Native_objects), &native_ob)
	image_width =  fmt.Sprintf("%v", native_ob["img_width"])
	image_height = fmt.Sprintf("%v", native_ob["img_height"])
	
	
	json.Unmarshal([]byte(adm), &adm_res)
	
   	for _,e := range adm_res.Native.Asset {
		if e.ID == 1 {
			title = e.Title.Text
		}
		if e.ID == 2 {
			logo = e.Img.URL
		}
		
		if e.ID == 3 { 
			image = e.Img.URL
		}
		
		if e.ID == 4 {		do_sponsored = e.Data.Value		}
		if e.ID == 5 {		do_description = e.Data.Value		}
		if e.ID == 6 {		do_ratting = e.Data.Value		}
		if e.ID == 7 {		do_likes = e.Data.Value		}
		if e.ID == 8 {		do_download = e.Data.Value		}
		if e.ID == 9 {		do_original_price = e.Data.Value		}
		if e.ID == 10 {		do_sales_price = e.Data.Value		}
		if e.ID == 11 {		do_phone = e.Data.Value		}
		if e.ID == 12 {		do_address = e.Data.Value		}
		if e.ID == 13 {		do_description2 = e.Data.Value		}
		if e.ID == 14 {		do_display_url = e.Data.Value		}
		if e.ID == 15 {		do_cta = e.Data.Value		}
	
	
	
	}  
	
		if adm_res.Native.Link.URL !=""  {

		clickTag_start = `<a href='` + adm_res.Native.Link.URL + `' target='_blank'>`
		clickTag_end = `</a>`
		
		}
	
	   	for _,e := range adm_res.Native.Imptrackers {

	impression += `<img src='` + e + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`

	}
	  
	

 
	 adTextStyle =` <style>
	.nv-main-container
	{
		
	}
	.nv-header
	{    display: table;
    width: 100%;
     padding: 5px 10px;
		
	}
	.nv-header-logo
	{
		           width: 32px;
    display: table-cell;
    vertical-align: middle;

	}
	.nv-header-logo img 
	{
		    max-width: 32px;
			max-height: 32px;
	}
	.nv-header-title h3
	{
		margin:auto;
	}
	.nv-header-title
	{
	    padding: 0px 15px;
    max-width: 70%;
    display: table-cell;
    vertical-align: middle;
	}
	.nv-header-price strike
	{
		      opacity: 0.7;
    color: #5c5959;
	}

	.nv-header-price
	{
	display: table-cell;
	width: 140px;
	max-width:25%;
    text-align: right;
    vertical-align: middle;
    color: #ff5252;
    font-weight: 600;

	}
	.nv-body
	{ padding: 5px 10px;
    text-align: justify;
    display: table;
    width: 100%;
		
	}
	.nv-body img
	{
		height:`+image_height+`px;
		width:`+image_width+`px;
		    float: left;
			padding-right: 10px;
			padding-bottom: 10px;

	}
	.nv-footer
	{       padding: 5px 10px;
    display: table;
    width: 100%;
		
	}
		.nv-footer .nv-footer-fr
		{
    display: table-cell;
    text-align: left;
		}
		
		.nv-footer .nv-footer-en
		{
    display: table-cell;
    text-align: left;
			
			
		}
		.nv-footer-phone , .nv-footer-str , .nv-footer-dow ,.nv-footer-like , .nv-footer-cta
		{
						    margin-bottom: 5px;

		}
		
 .nv-footer-cta button
		{
			    width: 100%;
    text-align: center;
    max-width: 150px;
    padding: 8px 15px;
    background: #2f2ff6;
    color: white;
    border: none;
}
		.nv-footer-address , .nv-footer-spons , .nv-footer-lk
		{
			    margin-bottom: 5px;

		}
	
</style>`





	adTextHeader=`<div class="nv-header">`
	if logo !="" {
		adTextHeader+=`<div class="nv-header-logo"><img src="`+logo+`"></div>`
		}
		
		if title !="" {
		adTextHeader+=`<div class="nv-header-title"><h3>`+title+`</h3></div>`
		}
		
		if do_original_price !="" && do_sales_price !="" {
		adTextHeader+=`<div class="nv-header-price"><strike>`+do_original_price+`</strike> &nbsp;`+do_sales_price+`</div>`
		} else if do_original_price !="" 	{
				adTextHeader+=`<div class="nv-header-price">`+do_original_price+`</div>`	
		} else	if do_sales_price !="" 	{
				adTextHeader+=`<div class="nv-header-price">`+do_sales_price+`</div>`	
		}
	adTextHeader+=`</div>`
	
	 
	 
	 
	 
	
		adTextBody=`<div class="nv-body">`
		
		if image !="" {
			adTextBody+=`<img class="nv-body-img" src="`+image+`">`
		}
			
		adTextBody+=do_description
		
		if  do_description2 !="" {
			
				adTextBody+=`<div>`+do_description+`</div>`
	
		} 
		
		adTextFooter = `<div class="nv-footer">
			
			<div class="nv-footer-fr">`
			if do_address !="" {
				adTextFooter+=`<div class="nv-footer-address">`+do_address+`</div>`
			}
				if do_sponsored !="" {
				adTextFooter+=`<div class="nv-footer-spons">`+do_sponsored+`</div>`
			}
				if do_display_url !="" {
				adTextFooter+=`<div class="nv-footer-lk"><a href="`+do_display_url+`">`+do_display_url+`</a></div>`
			}
			adTextFooter+=`</div>`
			
			
			
	 
	 
	 
			adTextFooter+=`<div class="nv-footer-en">`
			if do_phone !="" {
				adTextFooter+=`<div class="nv-footer-phone">`+do_phone+`	</div>`
			}
				if do_ratting !="" {
				adTextFooter+=`<div class="nv-footer-str"> `+do_ratting+` Star</div>`
			}
				if do_download !="" {
				adTextFooter+=`<div class="nv-footer-dow">Downloads : `+do_download+`</div>`
			}
				if do_likes !="" {
				adTextFooter+=`<div class="nv-footer-like">Likes : `+do_likes+`</div>`
			}
				if do_cta !="" {
				adTextFooter+=`<div class="nv-footer-cta">`+clickTag_start+`<button type="button">`+do_cta+`</button>`+clickTag_end+`</div>`
			}
				
			adTextFooter+=`</div>
			</div>`+impression
	  
	  
	  
	     
	 
return adTextStyle+`<div class="nv-main-container" >`+adTextHeader+adTextBody+adTextFooter+`</div>`	 			
	 			
	 			
	
   	 

}












func AdRenderNativeAd(adDetails *structure.AdDetails, zn structure.ZoneInfo) {
	
	   adDeliveryType := "web"
	   
	   var ImgTag ,clickurl string;
	   var clickTag_start ,clickTag_end string;
	   if adDetails.Url !=""  {
	clickurl = config.GetConfig( "protocol","webpath") + config.GetConfig("delivery","webpath") + "/ck.php?oaparams=2__bannerid=" + strconv.Itoa(adDetails.Ad_id) + "__campaignid=" + strconv.Itoa(adDetails.Placement_id) + "__zoneid="+ strconv.Itoa(zn.Zoneid)+"__oadest=" + adDetails.Url
		if adDeliveryType=="web" {	

	clickTag_start = `<a href='` + clickurl + `' target='_blank'>`
	clickTag_end = `</a>`
		}

	}
	
	impurl := config.GetConfig("protocol","webpath") + config.GetConfig("delivery","webpath") + "/lg.php?bannerid=" + strconv.Itoa(adDetails.Ad_id) + "&amp;campaignid=" + strconv.Itoa(adDetails.Placement_id) + "&amp;zoneid=" + strconv.Itoa(zn.Zoneid)
	
	
	if adDeliveryType=="web" {	
	ImgTag = `<img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
	}
	
	
	


	var native  map[interface{}]interface{}
	phpserialize.Unmarshal([]byte(adDetails.Parameters), &native)
	
 var data_objects map[string]interface{}
	json.Unmarshal([]byte(native["data_objects"].(string)), &data_objects)
	

	var adTextStyle, adTextHeader, adTextBody, adTextFooter string   
	var title, logo, image, image_width,image_height string
	var do_sponsored,do_description,do_ratting,do_likes,do_download,do_sales_price,do_original_price string     
	var do_phone,do_description2,do_address,do_display_url,do_cta string     
	  
	
	 
	 
	 if native["filename"] != nil {       image = config.GetConfig( "protocol","webpath") + config.GetConfig( "images","webpath") +`/`+native["filename"].(string)              }
	 
	 if native["is_icon_image"] != nil &&  native["is_icon_image"].(string)=="1" && native["icon_image"] != nil  {       
					logo =  config.GetConfig( "protocol","webpath") + config.GetConfig( "images","webpath") +`/`+native["icon_image"].(string)             }
					
	 if native["title"] != nil {       title = native["title"].(string)            }
	 if native["native_height"] != nil {       image_height = native["native_height"].(string)              }
	 if native["native_width"] != nil {       image_width = native["native_width"].(string)              }
	 

	 if data_objects["dj_data_address"] != nil {       do_address = data_objects["dj_data_address"].(string)             }
	 if data_objects["dj_data_ctatext"] != nil {       do_cta = data_objects["dj_data_ctatext"].(string)             }
	 if data_objects["dj_data_desc"] != nil {       do_description = data_objects["dj_data_desc"].(string)             }
	 if data_objects["dj_data_desc2"] != nil {       do_description2 = data_objects["dj_data_desc2"].(string)             }
	 if data_objects["dj_data_displayurl"] != nil {       do_display_url = data_objects["dj_data_displayurl"].(string)             }
	 if data_objects["dj_data_downloads"] != nil {       do_download = data_objects["dj_data_downloads"].(string)             }
	 if data_objects["dj_data_likes"] != nil {       do_likes = data_objects["dj_data_likes"].(string)             }
	 if data_objects["dj_data_phoneno"] != nil {       do_phone = data_objects["dj_data_phoneno"].(string)             }
	 if data_objects["dj_data_price"] != nil {       do_original_price = data_objects["dj_data_price"].(string)             }
	 if data_objects["dj_data_salesprice"] != nil {       do_sales_price = data_objects["dj_data_salesprice"].(string)             }
	 if data_objects["dj_data_sponsored"] != nil {       do_sponsored = data_objects["dj_data_sponsored"].(string)             }
	 if data_objects["dj_data_rating"] != nil {       do_ratting = data_objects["dj_data_rating"].(string)             }
	 
	 

 
	 adTextStyle =` <style>
	.nv-main-container
	{
		
	}
	.nv-header
	{    display: table;
    width: 100%;
     padding: 5px 10px;
		
	}
	.nv-header-logo
	{
		           width: 32px;
    display: table-cell;
    vertical-align: middle;

	}
	.nv-header-logo img 
	{
		    max-width: 32px;
			max-height: 32px;
	}
	.nv-header-title h3
	{
		margin:auto;
	}
	.nv-header-title
	{
	    padding: 0px 15px;
    max-width: 70%;
    display: table-cell;
    vertical-align: middle;
	}
	.nv-header-price strike
	{
		      opacity: 0.7;
    color: #5c5959;
	}

	.nv-header-price
	{
	display: table-cell;
	width: 140px;
	max-width:25%;
    text-align: right;
    vertical-align: middle;
    color: #ff5252;
    font-weight: 600;

	}
	.nv-body
	{ padding: 5px 10px;
    text-align: justify;
    display: table;
    width: 100%;
		
	}
	.nv-body img
	{
		height:`+image_height+`px;
		width:`+image_width+`px;
		    float: left;
			padding-right: 10px;
			padding-bottom: 10px;

	}
	.nv-footer
	{       padding: 5px 10px;
    display: table;
    width: 100%;
		
	}
		.nv-footer .nv-footer-fr
		{
    display: table-cell;
    text-align: left;
		}
		
		.nv-footer .nv-footer-en
		{
    display: table-cell;
    text-align: left;
			
			
		}
		.nv-footer-phone , .nv-footer-str , .nv-footer-dow ,.nv-footer-like , .nv-footer-cta
		{
						    margin-bottom: 5px;

		}
		
 .nv-footer-cta button
		{
			    width: 100%;
    text-align: center;
    max-width: 150px;
    padding: 8px 15px;
    background: #2f2ff6;
    color: white;
    border: none;
}
		.nv-footer-address , .nv-footer-spons , .nv-footer-lk
		{
			    margin-bottom: 5px;

		}
	
</style>`





	adTextHeader=`<div class="nv-header">`
	if logo !="" {
		adTextHeader+=`<div class="nv-header-logo"><img src="`+logo+`"></div>`
		}
		
		if title !="" {
		adTextHeader+=`<div class="nv-header-title"><h3>`+title+`</h3></div>`
		}
		
		if do_original_price !="" && do_sales_price !="" {
		adTextHeader+=`<div class="nv-header-price"><strike>`+do_original_price+`</strike> &nbsp;`+do_sales_price+`</div>`
		} else if do_original_price !="" 	{
				adTextHeader+=`<div class="nv-header-price">`+do_original_price+`</div>`	
		} else	if do_sales_price !="" 	{
				adTextHeader+=`<div class="nv-header-price">`+do_sales_price+`</div>`	
		}
	adTextHeader+=`</div>`
	
	 
	 
	 
	 
	
		adTextBody=`<div class="nv-body">`
		
		if image !="" {
			adTextBody+=`<img class="nv-body-img" src="`+image+`">`
		}
			
		adTextBody+=do_description
		
		if  do_description2 !="" {
			
				adTextBody+=`<div>`+do_description+`</div>`
	
		} 
		
		adTextFooter = `<div class="nv-footer">
			
			<div class="nv-footer-fr">`
			if do_address !="" {
				adTextFooter+=`<div class="nv-footer-address">`+do_address+`</div>`
			}
				if do_sponsored !="" {
				adTextFooter+=`<div class="nv-footer-spons">`+do_sponsored+`</div>`
			}
				if do_display_url !="" {
				adTextFooter+=`<div class="nv-footer-lk"><a href="`+do_display_url+`">`+do_display_url+`</a></div>`
			}
			adTextFooter+=`</div>`
			
			
			
	 
	 
	 
			adTextFooter+=`<div class="nv-footer-en">`
			if do_phone !="" {
				adTextFooter+=`<div class="nv-footer-phone">`+do_phone+`	</div>`
			}
				if do_ratting !="" {
				adTextFooter+=`<div class="nv-footer-str"> `+do_ratting+` Star</div>`
			}
				if do_download !="" {
				adTextFooter+=`<div class="nv-footer-dow">Downloads : `+do_download+`</div>`
			}
				if do_likes !="" {
				adTextFooter+=`<div class="nv-footer-like">Likes : `+do_likes+`</div>`
			}
				if do_cta !="" {
				adTextFooter+=`<div class="nv-footer-cta">`+clickTag_start+`<button type="button">`+do_cta+`</button>`+clickTag_end+`</div>`
			}
				
			adTextFooter+=`</div>
			</div>`+ImgTag
	  
	  
	  
	     
	 
	 			adDetails.Html=adTextStyle+`<div class="nv-main-container" >`+adTextHeader+adTextBody+adTextFooter+`</div>`
	 			
	 			
	
}




	
